/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.xml.util.ConverterAttributeMapValidator;
import org.eclipse.smarthome.config.xml.util.GenericUnmarshaller;
import org.eclipse.smarthome.config.xml.util.NodeIterator;
import org.eclipse.smarthome.config.xml.util.NodeList;
import org.eclipse.smarthome.config.xml.util.NodeValue;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateOption;

public class StateDescriptionConverter
extends GenericUnmarshaller<StateDescription> {
    protected ConverterAttributeMapValidator attributeMapValidator = new ConverterAttributeMapValidator((String[][])new String[][]{{"min", "false"}, {"max", "false"}, {"step", "false"}, {"pattern", "false"}, {"readOnly", "false"}});

    public StateDescriptionConverter() {
        super(StateDescription.class);
    }

    private BigDecimal toBigDecimal(Map<String, String> attributes, String attribute, BigDecimal defaultValue) throws ConversionException {
        String attrValueText = attributes.get(attribute);
        if (attrValueText != null) {
            try {
                return new BigDecimal(attrValueText);
            }
            catch (NumberFormatException nfe) {
                throw new ConversionException("The attribute '" + attribute + "' has not a valid decimal number format!", (Throwable)nfe);
            }
        }
        return defaultValue;
    }

    private boolean toBoolean(Map<String, String> attributes, String attribute, Boolean defaultValue) {
        String attrValueText = attributes.get(attribute);
        if (attrValueText != null) {
            return Boolean.valueOf(attrValueText);
        }
        return defaultValue;
    }

    private List<StateOption> toListOfChannelState(NodeList nodeList) throws ConversionException {
        if ("options".equals(nodeList.getNodeName())) {
            ArrayList<StateOption> stateOptions = new ArrayList<StateOption>();
            for (Object nodeObject : nodeList.getList()) {
                stateOptions.add(this.toChannelStateOption((NodeValue)nodeObject));
            }
            return stateOptions;
        }
        throw new ConversionException("Unknown type '" + nodeList.getNodeName() + "'!");
    }

    private StateOption toChannelStateOption(NodeValue nodeValue) throws ConversionException {
        if ("option".equals(nodeValue.getNodeName())) {
            Map attributes = nodeValue.getAttributes();
            if (attributes == null || !attributes.containsKey("value")) {
                throw new ConversionException("The node 'option' requires the attribute 'value'!");
            }
            String value = (String)attributes.get("value");
            String label = (String)nodeValue.getValue();
            return new StateOption(value, label);
        }
        throw new ConversionException("Unknown type in the list of 'options'!");
    }

    public final Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Map attributes = this.attributeMapValidator.readValidatedAttributes(reader);
        BigDecimal minimum = this.toBigDecimal(attributes, "min", null);
        BigDecimal maximum = this.toBigDecimal(attributes, "max", null);
        BigDecimal step = this.toBigDecimal(attributes, "step", null);
        String pattern = (String)attributes.get("pattern");
        boolean readOnly = this.toBoolean(attributes, "readOnly", false);
        List<StateOption> channelOptions = null;
        NodeList nodes = (NodeList)context.convertAnother((Object)context, NodeList.class);
        NodeIterator nodeIterator = new NodeIterator(nodes.getList());
        NodeList optionNodes = (NodeList)nodeIterator.next();
        if (optionNodes != null) {
            channelOptions = this.toListOfChannelState(optionNodes);
        }
        nodeIterator.assertEndOfType();
        StateDescription stateDescription = new StateDescription(minimum, maximum, step, pattern, readOnly, channelOptions);
        return stateDescription;
    }
}

