/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.internal.ThingImpl;
import org.eclipse.smarthome.core.thing.util.ThingHelper;

@NonNullByDefault
public class ThingBuilder {
    private final ThingImpl thing;

    protected ThingBuilder(ThingImpl thing) {
        this.thing = thing;
    }

    public static ThingBuilder create(ThingTypeUID thingTypeUID, String thingId) {
        ThingImpl thing = new ThingImpl(thingTypeUID, thingId);
        return new ThingBuilder(thing);
    }

    @Deprecated
    public static ThingBuilder create(ThingUID thingUID) {
        ThingImpl thing = new ThingImpl(thingUID);
        return new ThingBuilder(thing);
    }

    public static ThingBuilder create(ThingTypeUID thingTypeUID, ThingUID thingUID) {
        ThingImpl thing = new ThingImpl(thingTypeUID, thingUID);
        return new ThingBuilder(thing);
    }

    public ThingBuilder withLabel(@Nullable String label) {
        this.thing.setLabel(label);
        return this;
    }

    public ThingBuilder withChannel(Channel channel) {
        List<Channel> mutableThingChannels = this.thing.getChannelsMutable();
        this.validateChannelUIDs(Collections.singletonList(channel));
        ThingHelper.ensureUniqueChannels(mutableThingChannels, channel);
        mutableThingChannels.add(channel);
        return this;
    }

    public ThingBuilder withChannels(Channel ... channels) {
        return this.withChannels(Arrays.asList(channels));
    }

    public ThingBuilder withChannels(List<Channel> channels) {
        this.validateChannelUIDs(channels);
        ThingHelper.ensureUniqueChannels(channels);
        this.thing.setChannels(new ArrayList<Channel>(channels));
        return this;
    }

    public ThingBuilder withoutChannel(ChannelUID channelUID) {
        Iterator<Channel> iterator = this.thing.getChannelsMutable().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getUID().equals((Object)channelUID)) continue;
            iterator.remove();
            break;
        }
        return this;
    }

    public ThingBuilder withoutChannels(Channel ... channels) {
        return this.withoutChannels(Arrays.asList(channels));
    }

    public ThingBuilder withoutChannels(List<Channel> channels) {
        for (Channel channel : channels) {
            this.withoutChannel(channel.getUID());
        }
        return this;
    }

    public ThingBuilder withConfiguration(Configuration thingConfiguration) {
        this.thing.setConfiguration(thingConfiguration);
        return this;
    }

    public ThingBuilder withBridge(@Nullable ThingUID bridgeUID) {
        this.thing.setBridgeUID(bridgeUID);
        return this;
    }

    public ThingBuilder withProperties(Map<String, String> properties) {
        for (String key : properties.keySet()) {
            this.thing.setProperty(key, properties.get(key));
        }
        return this;
    }

    public ThingBuilder withLocation(@Nullable String location) {
        this.thing.setLocation(location);
        return this;
    }

    public Thing build() {
        return this.thing;
    }

    private void validateChannelUIDs(List<Channel> channels) {
        for (Channel channel : channels) {
            if (this.thing.getUID().equals((Object)channel.getUID().getThingUID())) continue;
            throw new IllegalArgumentException("Channel UID '" + (Object)((Object)channel.getUID()) + "' does not match thing UID '" + (Object)((Object)this.thing.getUID()) + "'");
        }
    }
}

