/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.events.AbstractEvent;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.firmware.FirmwareStatus;
import org.eclipse.smarthome.core.thing.firmware.FirmwareStatusInfo;

@NonNullByDefault
public final class FirmwareStatusInfoEvent
extends AbstractEvent {
    public static final String TYPE = FirmwareStatusInfoEvent.class.getSimpleName();
    private final FirmwareStatusInfo firmwareStatusInfo;

    protected FirmwareStatusInfoEvent(String topic, String payload, FirmwareStatusInfo firmwareStatusInfo) {
        super(topic, payload, null);
        this.firmwareStatusInfo = firmwareStatusInfo;
    }

    public FirmwareStatusInfo getFirmwareStatusInfo() {
        return this.firmwareStatusInfo;
    }

    public String getType() {
        return TYPE;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.firmwareStatusInfo == null ? 0 : this.firmwareStatusInfo.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FirmwareStatusInfoEvent other = (FirmwareStatusInfoEvent)((Object)obj);
        return !(this.firmwareStatusInfo == null ? other.firmwareStatusInfo != null : !this.firmwareStatusInfo.equals(other.firmwareStatusInfo));
    }

    public String toString() {
        FirmwareStatus status = this.firmwareStatusInfo.getFirmwareStatus();
        ThingUID thingUID = this.firmwareStatusInfo.getThingUID();
        StringBuilder sb = new StringBuilder(String.format("Firmware status of thing %s changed to %s.", new Object[]{thingUID, status.name()}));
        if (status == FirmwareStatus.UPDATE_EXECUTABLE) {
            sb.append(String.format("The new updatable firmware version is %s.", this.firmwareStatusInfo.getUpdatableFirmwareVersion()));
        }
        return sb.toString();
    }
}

