/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.type.BridgeType;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;
import org.eclipse.smarthome.core.thing.type.ThingType;

@NonNullByDefault
public class ThingTypeBuilder {
    private @Nullable List<ChannelGroupDefinition> channelGroupDefinitions;
    private @Nullable List<ChannelDefinition> channelDefinitions;
    private @Nullable List<String> extensibleChannelTypeIds;
    private @Nullable List<String> supportedBridgeTypeUIDs;
    private @Nullable Map<String, String> properties;
    private @Nullable String representationProperty;
    private @Nullable URI configDescriptionURI;
    private boolean listed;
    private @Nullable String category;
    private @Nullable String description;
    private final String bindingId;
    private final String thingTypeId;
    private String label;

    public static ThingTypeBuilder instance(String bindingId, String thingTypeId, String label) {
        return new ThingTypeBuilder(bindingId, thingTypeId, label);
    }

    public static ThingTypeBuilder instance(ThingTypeUID thingTypeUID, String label) {
        return new ThingTypeBuilder(thingTypeUID.getBindingId(), thingTypeUID.getId(), label);
    }

    public static ThingTypeBuilder instance(ThingType thingType) {
        return new ThingTypeBuilder(thingType);
    }

    private ThingTypeBuilder(String bindingId, String thingTypeId, String label) {
        this.bindingId = bindingId;
        this.thingTypeId = thingTypeId;
        this.label = label;
        this.listed = true;
    }

    private ThingTypeBuilder(ThingType thingType) {
        this(thingType.getBindingId(), thingType.getUID().getId(), thingType.getLabel());
        this.description = thingType.getDescription();
        this.channelGroupDefinitions = thingType.getChannelGroupDefinitions();
        this.channelDefinitions = thingType.getChannelDefinitions();
        this.extensibleChannelTypeIds = thingType.getExtensibleChannelTypeIds();
        this.supportedBridgeTypeUIDs = thingType.getSupportedBridgeTypeUIDs();
        this.properties = thingType.getProperties();
        this.representationProperty = thingType.getRepresentationProperty();
        this.configDescriptionURI = thingType.getConfigDescriptionURI();
        this.listed = thingType.isListed();
        this.category = thingType.getCategory();
    }

    public ThingType build() {
        if (StringUtils.isBlank((String)this.bindingId)) {
            throw new IllegalArgumentException("The bindingId must neither be null nor empty.");
        }
        if (StringUtils.isBlank((String)this.thingTypeId)) {
            throw new IllegalArgumentException("The thingTypeId must neither be null nor empty.");
        }
        if (StringUtils.isBlank((String)this.label)) {
            throw new IllegalArgumentException("The label must neither be null nor empty.");
        }
        return new ThingType(new ThingTypeUID(this.bindingId, this.thingTypeId), this.supportedBridgeTypeUIDs, this.label, this.description, this.category, this.listed, this.representationProperty, this.channelDefinitions, this.channelGroupDefinitions, this.properties, this.configDescriptionURI, this.extensibleChannelTypeIds);
    }

    public BridgeType buildBridge() {
        if (StringUtils.isBlank((String)this.bindingId)) {
            throw new IllegalArgumentException("The bindingId must neither be null nor empty.");
        }
        if (StringUtils.isBlank((String)this.thingTypeId)) {
            throw new IllegalArgumentException("The thingTypeId must neither be null nor empty.");
        }
        if (StringUtils.isBlank((String)this.label)) {
            throw new IllegalArgumentException("The label must neither be null nor empty.");
        }
        return new BridgeType(new ThingTypeUID(this.bindingId, this.thingTypeId), this.supportedBridgeTypeUIDs, this.label, this.description, this.category, this.listed, this.representationProperty, this.channelDefinitions, this.channelGroupDefinitions, this.properties, this.configDescriptionURI, this.extensibleChannelTypeIds);
    }

    public ThingTypeBuilder withLabel(String label) {
        this.label = label;
        return this;
    }

    public ThingTypeBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public ThingTypeBuilder withCategory(String category) {
        this.category = category;
        return this;
    }

    public ThingTypeBuilder isListed(boolean listed) {
        this.listed = listed;
        return this;
    }

    public ThingTypeBuilder withRepresentationProperty(String representationProperty) {
        this.representationProperty = representationProperty;
        return this;
    }

    public ThingTypeBuilder withChannelDefinitions(List<ChannelDefinition> channelDefinitions) {
        this.channelDefinitions = channelDefinitions;
        return this;
    }

    public ThingTypeBuilder withChannelGroupDefinitions(List<ChannelGroupDefinition> channelGroupDefinitions) {
        this.channelGroupDefinitions = channelGroupDefinitions;
        return this;
    }

    public ThingTypeBuilder withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public ThingTypeBuilder withConfigDescriptionURI(URI configDescriptionURI) {
        this.configDescriptionURI = configDescriptionURI;
        return this;
    }

    public ThingTypeBuilder withExtensibleChannelTypeIds(List<String> extensibleChannelTypeIds) {
        this.extensibleChannelTypeIds = extensibleChannelTypeIds;
        return this;
    }

    public ThingTypeBuilder withSupportedBridgeTypeUIDs(List<String> supportedBridgeTypeUIDs) {
        this.supportedBridgeTypeUIDs = supportedBridgeTypeUIDs;
        return this;
    }
}

