/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.voice;

import org.eclipse.smarthome.core.voice.STTEvent;

public class SpeechRecognitionEvent
implements STTEvent {
    private final float confidence;
    private final String transcript;

    public SpeechRecognitionEvent(String transcript, float confidence) {
        if (transcript == null || transcript.isEmpty()) {
            throw new IllegalArgumentException("The passed transcript is null or empty");
        }
        if ((double)confidence < 0.0 || 1.0 < (double)confidence) {
            throw new IllegalArgumentException("The passed confidence is less than 0.0 or greater than 1.0");
        }
        this.transcript = transcript;
        this.confidence = confidence;
    }

    public String getTranscript() {
        return this.transcript;
    }

    public float getConfidence() {
        return this.confidence;
    }
}

