/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.voice.internal;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.smarthome.core.audio.AudioException;
import org.eclipse.smarthome.core.audio.AudioFormat;
import org.eclipse.smarthome.core.audio.AudioSink;
import org.eclipse.smarthome.core.audio.AudioSource;
import org.eclipse.smarthome.core.audio.AudioStream;
import org.eclipse.smarthome.core.audio.UnsupportedAudioFormatException;
import org.eclipse.smarthome.core.audio.UnsupportedAudioStreamException;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.ItemUtil;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.voice.KSErrorEvent;
import org.eclipse.smarthome.core.voice.KSEvent;
import org.eclipse.smarthome.core.voice.KSException;
import org.eclipse.smarthome.core.voice.KSListener;
import org.eclipse.smarthome.core.voice.KSService;
import org.eclipse.smarthome.core.voice.KSpottedEvent;
import org.eclipse.smarthome.core.voice.RecognitionStopEvent;
import org.eclipse.smarthome.core.voice.STTEvent;
import org.eclipse.smarthome.core.voice.STTException;
import org.eclipse.smarthome.core.voice.STTListener;
import org.eclipse.smarthome.core.voice.STTService;
import org.eclipse.smarthome.core.voice.STTServiceHandle;
import org.eclipse.smarthome.core.voice.SpeechRecognitionErrorEvent;
import org.eclipse.smarthome.core.voice.SpeechRecognitionEvent;
import org.eclipse.smarthome.core.voice.TTSException;
import org.eclipse.smarthome.core.voice.TTSService;
import org.eclipse.smarthome.core.voice.Voice;
import org.eclipse.smarthome.core.voice.text.HumanLanguageInterpreter;
import org.eclipse.smarthome.core.voice.text.InterpretationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogProcessor
implements KSListener,
STTListener {
    private final Logger logger = LoggerFactory.getLogger(DialogProcessor.class);
    private boolean processing = false;
    private boolean isSTTServerAborting = false;
    private STTServiceHandle sttServiceHandle;
    private final KSService ks;
    private final STTService stt;
    private final TTSService tts;
    private final HumanLanguageInterpreter hli;
    private final AudioSource source;
    private final AudioSink sink;
    private final Locale locale;
    private final String keyword;
    private final String listeningItem;
    private final EventPublisher eventPublisher;
    private final AudioFormat format;

    public DialogProcessor(KSService ks, STTService stt, TTSService tts, HumanLanguageInterpreter hli, AudioSource source, AudioSink sink, Locale locale, String keyword, String listeningItem, EventPublisher eventPublisher) {
        this.locale = locale;
        this.ks = ks;
        this.hli = hli;
        this.stt = stt;
        this.tts = tts;
        this.source = source;
        this.sink = sink;
        this.keyword = keyword;
        this.listeningItem = listeningItem;
        this.eventPublisher = eventPublisher;
        this.format = AudioFormat.getBestMatch((Set)source.getSupportedFormats(), (Set)sink.getSupportedFormats());
    }

    public void start() {
        try {
            this.ks.spot(this, this.source.getInputStream(this.format), this.locale, this.keyword);
        }
        catch (KSException e) {
            this.logger.error("Encountered error calling spot: {}", (Object)e.getMessage());
        }
        catch (AudioException e) {
            this.logger.error("Error creating the audio stream", (Throwable)e);
        }
    }

    private void toggleProcessing(boolean value) {
        if (this.processing == value) {
            return;
        }
        this.processing = value;
        if (this.listeningItem != null && ItemUtil.isValidItemName((String)this.listeningItem)) {
            OnOffType command = value ? OnOffType.ON : OnOffType.OFF;
            this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)this.listeningItem, (Command)command));
        }
    }

    @Override
    public void ksEventReceived(KSEvent ksEvent) {
        if (!this.processing) {
            this.isSTTServerAborting = false;
            if (ksEvent instanceof KSpottedEvent) {
                this.toggleProcessing(true);
                if (this.stt != null) {
                    try {
                        this.sttServiceHandle = this.stt.recognize(this, this.source.getInputStream(this.format), this.locale, new HashSet<String>());
                    }
                    catch (STTException e) {
                        this.say("Error during recognition: " + e.getMessage());
                    }
                    catch (AudioException e) {
                        this.logger.error("Error creating the audio stream", (Throwable)e);
                    }
                }
            } else if (ksEvent instanceof KSErrorEvent) {
                KSErrorEvent kse = (KSErrorEvent)ksEvent;
                this.say("Encountered error spotting keywords, " + kse.getMessage());
            }
        }
    }

    @Override
    public synchronized void sttEventReceived(STTEvent sttEvent) {
        if (sttEvent instanceof SpeechRecognitionEvent) {
            if (!this.isSTTServerAborting) {
                this.sttServiceHandle.abort();
                this.isSTTServerAborting = true;
                SpeechRecognitionEvent sre = (SpeechRecognitionEvent)sttEvent;
                String question = sre.getTranscript();
                try {
                    this.toggleProcessing(false);
                    String answer = this.hli.interpret(this.locale, question);
                    if (answer != null) {
                        this.say(answer);
                    }
                }
                catch (InterpretationException e) {
                    this.say(e.getMessage());
                }
            }
        } else if (sttEvent instanceof RecognitionStopEvent) {
            this.toggleProcessing(false);
        } else if (sttEvent instanceof SpeechRecognitionErrorEvent && !this.isSTTServerAborting) {
            this.sttServiceHandle.abort();
            this.isSTTServerAborting = true;
            this.toggleProcessing(false);
            SpeechRecognitionErrorEvent sre = (SpeechRecognitionErrorEvent)sttEvent;
            this.say("Encountered error: " + sre.getMessage());
        }
    }

    protected void say(String text) {
        try {
            Voice voice = null;
            for (Voice currentVoice : this.tts.getAvailableVoices()) {
                if (!this.locale.getLanguage().equals(currentVoice.getLocale().getLanguage())) continue;
                voice = currentVoice;
                break;
            }
            if (voice == null) {
                throw new TTSException("Unable to find a suitable voice");
            }
            AudioStream audioStream = this.tts.synthesize(text, voice, null);
            if (this.sink.getSupportedStreams().stream().anyMatch(clazz -> clazz.isInstance(audioStream))) {
                try {
                    this.sink.process(audioStream);
                }
                catch (UnsupportedAudioFormatException | UnsupportedAudioStreamException e) {
                    this.logger.warn("Error saying '{}': {}", new Object[]{text, e.getMessage(), e});
                }
            } else {
                this.logger.warn("Failed playing audio stream '{}' as audio doesn't support it.", (Object)audioStream);
            }
        }
        catch (TTSException e) {
            this.logger.error("Error saying '{}': {}", (Object)text, (Object)e.getMessage());
        }
    }
}

