/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.voice.internal;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.ConfigOptionProvider;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.core.audio.AudioFormat;
import org.eclipse.smarthome.core.audio.AudioManager;
import org.eclipse.smarthome.core.audio.AudioSink;
import org.eclipse.smarthome.core.audio.AudioSource;
import org.eclipse.smarthome.core.audio.AudioStream;
import org.eclipse.smarthome.core.audio.UnsupportedAudioFormatException;
import org.eclipse.smarthome.core.audio.UnsupportedAudioStreamException;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.voice.KSService;
import org.eclipse.smarthome.core.voice.STTService;
import org.eclipse.smarthome.core.voice.TTSException;
import org.eclipse.smarthome.core.voice.TTSService;
import org.eclipse.smarthome.core.voice.Voice;
import org.eclipse.smarthome.core.voice.VoiceManager;
import org.eclipse.smarthome.core.voice.internal.DialogProcessor;
import org.eclipse.smarthome.core.voice.text.HumanLanguageInterpreter;
import org.eclipse.smarthome.core.voice.text.InterpretationException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid="org.eclipse.smarthome.voice", property={"service.pid=org.eclipse.smarthome.voice", "service.config.category=system", "service.config.label=Voice", "service.config.description.uri=system:voice"})
public class VoiceManagerImpl
implements VoiceManager,
ConfigOptionProvider {
    private static final String DEFAULT_KEYWORD = "Wakeup";
    protected static final String CONFIG_URI = "system:voice";
    private static final String CONFIG_KEYWORD = "keyword";
    private static final String CONFIG_LISTENING_ITEM = "listeningItem";
    private static final String CONFIG_DEFAULT_HLI = "defaultHLI";
    private static final String CONFIG_DEFAULT_KS = "defaultKS";
    private static final String CONFIG_DEFAULT_STT = "defaultSTT";
    private static final String CONFIG_DEFAULT_TTS = "defaultTTS";
    private static final String CONFIG_DEFAULT_VOICE = "defaultVoice";
    private static final String CONFIG_PREFIX_DEFAULT_VOICE = "defaultVoice.";
    private final Logger logger = LoggerFactory.getLogger(VoiceManagerImpl.class);
    private final Map<String, KSService> ksServices = new HashMap<String, KSService>();
    private final Map<String, STTService> sttServices = new HashMap<String, STTService>();
    private final Map<String, TTSService> ttsServices = new HashMap<String, TTSService>();
    private final Map<String, HumanLanguageInterpreter> humanLanguageInterpreters = new HashMap<String, HumanLanguageInterpreter>();
    private LocaleProvider localeProvider = null;
    private String keyword = "Wakeup";
    private String listeningItem = null;
    private String defaultTTS = null;
    private String defaultSTT = null;
    private String defaultKS = null;
    private String defaultHLI = null;
    private String defaultVoice = null;
    private final Map<String, String> defaultVoices = new HashMap<String, String>();
    private AudioManager audioManager;
    private EventPublisher eventPublisher;

    @Activate
    protected void activate(Map<String, Object> config) {
        this.modified(config);
    }

    @Deactivate
    protected void deactivate() {
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        if (config != null) {
            this.keyword = config.containsKey(CONFIG_KEYWORD) ? config.get(CONFIG_KEYWORD).toString() : DEFAULT_KEYWORD;
            this.listeningItem = config.containsKey(CONFIG_LISTENING_ITEM) ? config.get(CONFIG_LISTENING_ITEM).toString() : null;
            this.defaultTTS = config.containsKey(CONFIG_DEFAULT_TTS) ? config.get(CONFIG_DEFAULT_TTS).toString() : null;
            this.defaultSTT = config.containsKey(CONFIG_DEFAULT_STT) ? config.get(CONFIG_DEFAULT_STT).toString() : null;
            this.defaultKS = config.containsKey(CONFIG_DEFAULT_KS) ? config.get(CONFIG_DEFAULT_KS).toString() : null;
            this.defaultHLI = config.containsKey(CONFIG_DEFAULT_HLI) ? config.get(CONFIG_DEFAULT_HLI).toString() : null;
            this.defaultVoice = config.containsKey(CONFIG_DEFAULT_VOICE) ? config.get(CONFIG_DEFAULT_VOICE).toString() : null;
            for (String key : config.keySet()) {
                if (!key.startsWith(CONFIG_PREFIX_DEFAULT_VOICE)) continue;
                String tts = key.substring(CONFIG_PREFIX_DEFAULT_VOICE.length());
                this.defaultVoices.put(tts, config.get(key).toString());
            }
        }
    }

    @Override
    public void say(String text) {
        this.say(text, null, null, null);
    }

    @Override
    public void say(String text, PercentType volume) {
        this.say(text, null, null, volume);
    }

    @Override
    public void say(String text, String voiceId) {
        this.say(text, voiceId, null, null);
    }

    @Override
    public void say(String text, String voiceId, PercentType volume) {
        this.say(text, voiceId, null, volume);
    }

    @Override
    public void say(String text, String voiceId, String sinkId) {
        this.say(text, voiceId, sinkId, null);
    }

    @Override
    public void say(String text, String voiceId, String sinkId, PercentType volume) {
        block29: {
            Objects.requireNonNull(text, "Text cannot be said as it is null.");
            try {
                TTSService tts = null;
                Voice voice = null;
                String selectedVoiceId = voiceId;
                if (selectedVoiceId == null) {
                    selectedVoiceId = this.defaultVoice;
                }
                if (selectedVoiceId == null) {
                    tts = this.getTTS();
                    if (tts != null) {
                        voice = this.getPreferredVoice(tts.getAvailableVoices());
                    }
                } else {
                    voice = this.getVoice(selectedVoiceId);
                    if (voice != null) {
                        tts = this.getTTS(voice);
                    }
                }
                if (tts == null) {
                    throw new TTSException("No TTS service can be found for voice " + selectedVoiceId);
                }
                if (voice == null) {
                    throw new TTSException("Unable to find a voice for language " + this.localeProvider.getLocale().getLanguage());
                }
                Set<AudioFormat> audioFormats = tts.getSupportedFormats();
                AudioSink sink = this.audioManager.getSink(sinkId);
                if (sink == null) break block29;
                AudioFormat audioFormat = VoiceManagerImpl.getBestMatch(audioFormats, sink.getSupportedFormats());
                if (audioFormat != null) {
                    AudioStream audioStream = tts.synthesize(text, voice, audioFormat);
                    if (sink.getSupportedStreams().stream().anyMatch(clazz -> clazz.isInstance(audioStream))) {
                        PercentType oldVolume = null;
                        try {
                            oldVolume = this.audioManager.getVolume(sinkId);
                        }
                        catch (IOException e) {
                            this.logger.debug("An exception occurred while getting the volume of sink '{}' : {}", new Object[]{sink.getId(), e.getMessage(), e});
                        }
                        if (volume != null) {
                            try {
                                this.audioManager.setVolume(volume, sinkId);
                            }
                            catch (IOException e) {
                                this.logger.debug("An exception occurred while setting the volume of sink '{}' : {}", new Object[]{sink.getId(), e.getMessage(), e});
                            }
                        }
                        try {
                            try {
                                sink.process(audioStream);
                            }
                            catch (UnsupportedAudioFormatException | UnsupportedAudioStreamException e) {
                                this.logger.warn("Error saying '{}': {}", new Object[]{text, e.getMessage(), e});
                                if (volume != null && oldVolume != null) {
                                    try {
                                        this.audioManager.setVolume(oldVolume, sinkId);
                                    }
                                    catch (IOException e2) {
                                        this.logger.debug("An exception occurred while setting the volume of sink '{}' : {}", new Object[]{sink.getId(), e2.getMessage(), e2});
                                    }
                                }
                                break block29;
                            }
                        }
                        catch (Throwable throwable) {
                            if (volume != null && oldVolume != null) {
                                try {
                                    this.audioManager.setVolume(oldVolume, sinkId);
                                }
                                catch (IOException e) {
                                    this.logger.debug("An exception occurred while setting the volume of sink '{}' : {}", new Object[]{sink.getId(), e.getMessage(), e});
                                }
                            }
                            throw throwable;
                        }
                        if (volume != null && oldVolume != null) {
                            try {
                                this.audioManager.setVolume(oldVolume, sinkId);
                            }
                            catch (IOException e) {
                                this.logger.debug("An exception occurred while setting the volume of sink '{}' : {}", new Object[]{sink.getId(), e.getMessage(), e});
                            }
                        }
                        break block29;
                    }
                    this.logger.warn("Failed playing audio stream '{}' as audio sink doesn't support it.", (Object)audioStream);
                    break block29;
                }
                this.logger.warn("No compatible audio format found for TTS '{}' and sink '{}'", (Object)tts.getId(), (Object)sink.getId());
            }
            catch (TTSException e) {
                this.logger.warn("Error saying '{}': {}", new Object[]{text, e.getMessage(), e});
            }
        }
    }

    @Override
    public String interpret(String text) throws InterpretationException {
        return this.interpret(text, null);
    }

    @Override
    public String interpret(String text, String hliId) throws InterpretationException {
        HumanLanguageInterpreter interpreter;
        if (hliId == null) {
            interpreter = this.getHLI();
            if (interpreter == null) {
                throw new InterpretationException("No human language interpreter available!");
            }
        } else {
            interpreter = this.getHLI(hliId);
            if (interpreter == null) {
                throw new InterpretationException("No human language interpreter can be found for " + hliId);
            }
        }
        return interpreter.interpret(this.localeProvider.getLocale(), text);
    }

    private Voice getVoice(String id) {
        if (id.contains(":")) {
            String[] segments = id.split(":");
            TTSService tts = this.getTTS(segments[0]);
            if (tts != null) {
                return this.getVoice(tts.getAvailableVoices(), segments[1]);
            }
        } else {
            TTSService tts = this.getTTS();
            if (tts != null) {
                return this.getVoice(tts.getAvailableVoices(), id);
            }
        }
        return null;
    }

    private Voice getVoice(Set<Voice> voices, String id) {
        for (Voice voice : voices) {
            if (!voice.getUID().endsWith(":" + id)) continue;
            return voice;
        }
        return null;
    }

    public static AudioFormat getPreferredFormat(Set<AudioFormat> audioFormats) {
        for (AudioFormat currentAudioFormat : audioFormats) {
            if (currentAudioFormat.getCodec() == null || currentAudioFormat.getContainer() == null || currentAudioFormat.isBigEndian() == null || currentAudioFormat.getBitDepth() == null || currentAudioFormat.getBitRate() == null || currentAudioFormat.getFrequency() == null || !currentAudioFormat.getContainer().equals("WAVE")) continue;
            return currentAudioFormat;
        }
        for (AudioFormat currentAudioFormat : audioFormats) {
            AudioFormat format = currentAudioFormat;
            if (format.getCodec() == null || format.getContainer() == null || !format.getContainer().equals("WAVE")) continue;
            if (format.isBigEndian() == null) {
                format = new AudioFormat(format.getContainer(), format.getCodec(), new Boolean(true), format.getBitDepth(), format.getBitRate(), format.getFrequency());
            }
            if (format.getBitDepth() == null || format.getBitRate() == null || format.getFrequency() == null) {
                int defaultBitDepth = 16;
                long defaultFrequency = 44100L;
                Integer bitRate = format.getBitRate();
                Long frequency = format.getFrequency();
                Integer bitDepth = format.getBitDepth();
                if (bitRate == null) {
                    if (bitDepth == null) {
                        bitDepth = new Integer(defaultBitDepth);
                    }
                    if (frequency == null) {
                        frequency = new Long(defaultFrequency);
                    }
                    bitRate = new Integer(bitDepth * frequency.intValue());
                } else if (bitDepth == null) {
                    if (frequency == null) {
                        frequency = new Long(defaultFrequency);
                    }
                    bitDepth = new Integer(bitRate / frequency.intValue());
                } else if (frequency == null) {
                    frequency = new Long(bitRate.longValue() / bitDepth.longValue());
                }
                format = new AudioFormat(format.getContainer(), format.getCodec(), format.isBigEndian(), bitDepth, bitRate, frequency);
            }
            return format;
        }
        return null;
    }

    public static AudioFormat getBestMatch(Set<AudioFormat> inputs, Set<AudioFormat> outputs) {
        AudioFormat preferredFormat = VoiceManagerImpl.getPreferredFormat(inputs);
        for (AudioFormat output : outputs) {
            if (output.isCompatible(preferredFormat)) {
                return preferredFormat;
            }
            for (AudioFormat input : inputs) {
                if (!output.isCompatible(input)) continue;
                return input;
            }
        }
        return null;
    }

    @Override
    public Voice getPreferredVoice(Set<Voice> voices) {
        Locale locale = this.localeProvider.getLocale();
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (Voice currentVoice : voices) {
            locales.add(currentVoice.getLocale());
        }
        String ranges = locale.toLanguageTag();
        List<Locale.LanguageRange> languageRanges = Locale.LanguageRange.parse(String.valueOf(ranges) + "-*");
        Locale preferredLocale = Locale.lookup(languageRanges, locales);
        if (preferredLocale == null) {
            preferredLocale = (Locale)locales.iterator().next();
        }
        Voice preferredVoice = null;
        for (Voice currentVoice : voices) {
            if (!preferredLocale.equals(currentVoice.getLocale())) continue;
            preferredVoice = currentVoice;
        }
        assert (preferredVoice != null);
        return preferredVoice;
    }

    @Override
    public void startDialog() {
        this.startDialog(null, null, null, null, null, null, null, this.keyword, this.listeningItem);
    }

    @Override
    public void startDialog(KSService ksService, STTService sttService, TTSService ttsService, HumanLanguageInterpreter interpreter, AudioSource audioSource, AudioSink audioSink, Locale locale, String keyword, String listeningItem) {
        String item;
        KSService ks = ksService == null ? this.getKS() : ksService;
        STTService stt = sttService == null ? this.getSTT() : sttService;
        TTSService tts = ttsService == null ? this.getTTS() : ttsService;
        HumanLanguageInterpreter hli = interpreter == null ? this.getHLI() : interpreter;
        AudioSource source = audioSource == null ? this.audioManager.getSource() : audioSource;
        AudioSink sink = audioSink == null ? this.audioManager.getSink() : audioSink;
        Locale loc = locale == null ? this.localeProvider.getLocale() : locale;
        String kw = keyword == null ? this.keyword : keyword;
        String string = item = listeningItem == null ? this.listeningItem : listeningItem;
        if (ks == null || stt == null || tts == null || hli == null || source == null || sink == null || loc == null || kw == null) {
            String msg = "Cannot start dialog as services are missing.";
            this.logger.error(msg);
            throw new IllegalStateException(msg);
        }
        DialogProcessor processor = new DialogProcessor(ks, stt, tts, hli, source, sink, loc, kw, item, this.eventPublisher);
        processor.start();
    }

    @Reference
    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addKSService(KSService ksService) {
        this.ksServices.put(ksService.getId(), ksService);
    }

    protected void removeKSService(KSService ksService) {
        this.ksServices.remove(ksService.getId());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addSTTService(STTService sttService) {
        this.sttServices.put(sttService.getId(), sttService);
    }

    protected void removeSTTService(STTService sttService) {
        this.sttServices.remove(sttService.getId());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addTTSService(TTSService ttsService) {
        this.ttsServices.put(ttsService.getId(), ttsService);
    }

    protected void removeTTSService(TTSService ttsService) {
        this.ttsServices.remove(ttsService.getId());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addHumanLanguageInterpreter(HumanLanguageInterpreter humanLanguageInterpreter) {
        this.humanLanguageInterpreters.put(humanLanguageInterpreter.getId(), humanLanguageInterpreter);
    }

    protected void removeHumanLanguageInterpreter(HumanLanguageInterpreter humanLanguageInterpreter) {
        this.humanLanguageInterpreters.remove(humanLanguageInterpreter.getId());
    }

    @Reference
    protected void setAudioManager(AudioManager audioManager) {
        this.audioManager = audioManager;
    }

    protected void unsetAudioManager(AudioManager audioManager) {
        this.audioManager = null;
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    @Override
    public TTSService getTTS() {
        TTSService tts = null;
        if (this.defaultTTS != null) {
            tts = this.ttsServices.get(this.defaultTTS);
            if (tts == null) {
                this.logger.warn("Default TTS service '{}' not available!", (Object)this.defaultTTS);
            }
        } else if (!this.ttsServices.isEmpty()) {
            tts = this.ttsServices.values().iterator().next();
        } else {
            this.logger.debug("No TTS service available!");
        }
        return tts;
    }

    @Override
    public TTSService getTTS(String id) {
        return this.ttsServices.get(id);
    }

    private TTSService getTTS(Voice voice) {
        return this.getTTS(voice.getUID().split(":")[0]);
    }

    @Override
    public Collection<TTSService> getTTSs() {
        return new HashSet<TTSService>(this.ttsServices.values());
    }

    @Override
    public STTService getSTT() {
        STTService stt = null;
        if (this.defaultTTS != null) {
            stt = this.sttServices.get(this.defaultSTT);
            if (stt == null) {
                this.logger.warn("Default STT service '{}' not available!", (Object)this.defaultSTT);
            }
        } else if (!this.sttServices.isEmpty()) {
            stt = this.sttServices.values().iterator().next();
        } else {
            this.logger.debug("No STT service available!");
        }
        return stt;
    }

    @Override
    public STTService getSTT(String id) {
        return this.sttServices.get(id);
    }

    @Override
    public Collection<STTService> getSTTs() {
        return new HashSet<STTService>(this.sttServices.values());
    }

    @Override
    public KSService getKS() {
        KSService ks = null;
        if (this.defaultKS != null) {
            ks = this.ksServices.get(this.defaultKS);
            if (ks == null) {
                this.logger.warn("Default KS service '{}' not available!", (Object)this.defaultKS);
            }
        } else if (!this.ksServices.isEmpty()) {
            ks = this.ksServices.values().iterator().next();
        } else {
            this.logger.debug("No KS service available!");
        }
        return ks;
    }

    @Override
    public KSService getKS(String id) {
        return this.ksServices.get(id);
    }

    @Override
    public Collection<KSService> getKSs() {
        return new HashSet<KSService>(this.ksServices.values());
    }

    @Override
    public HumanLanguageInterpreter getHLI() {
        HumanLanguageInterpreter hli = null;
        if (this.defaultHLI != null) {
            hli = this.humanLanguageInterpreters.get(this.defaultHLI);
            if (hli == null) {
                this.logger.warn("Default HumanLanguageInterpreter '{}' not available!", (Object)this.defaultHLI);
            }
        } else if (!this.humanLanguageInterpreters.isEmpty()) {
            hli = this.humanLanguageInterpreters.values().iterator().next();
        } else {
            this.logger.debug("No HumanLanguageInterpreter available!");
        }
        return hli;
    }

    @Override
    public HumanLanguageInterpreter getHLI(String id) {
        return this.humanLanguageInterpreters.get(id);
    }

    @Override
    public Collection<HumanLanguageInterpreter> getHLIs() {
        return new HashSet<HumanLanguageInterpreter>(this.humanLanguageInterpreters.values());
    }

    @Override
    public Set<Voice> getAllVoices() {
        return this.getAllVoicesSorted(this.localeProvider.getLocale());
    }

    private Set<Voice> getAllVoicesSorted(Locale locale) {
        return this.ttsServices.values().stream().map(s -> s.getAvailableVoices()).flatMap(Collection::stream).sorted(this.createVoiceComparator(locale)).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    private Comparator<Voice> createVoiceComparator(Locale locale) {
        Comparator byTTSLabel = (v1, v2) -> this.getTTS((Voice)v1).getLabel(locale).compareToIgnoreCase(this.getTTS((Voice)v2).getLabel(locale));
        Comparator byVoiceLocale = (v1, v2) -> v1.getLocale().getDisplayName(locale).compareToIgnoreCase(v2.getLocale().getDisplayName(locale));
        return byTTSLabel.thenComparing(byVoiceLocale).thenComparing(Voice::getLabel);
    }

    @Override
    public @Nullable Voice getDefaultVoice() {
        return this.defaultVoice != null ? this.getVoice(this.defaultVoice) : null;
    }

    public Collection<ParameterOption> getParameterOptions(URI uri, String param, Locale locale) {
        if (uri.toString().equals(CONFIG_URI)) {
            if (CONFIG_DEFAULT_HLI.equals(param)) {
                return this.humanLanguageInterpreters.values().stream().sorted((hli1, hli2) -> hli1.getLabel(locale).compareToIgnoreCase(hli2.getLabel(locale))).map(hli -> new ParameterOption(hli.getId(), hli.getLabel(locale))).collect(Collectors.toList());
            }
            if (CONFIG_DEFAULT_KS.equals(param)) {
                return this.ksServices.values().stream().sorted((ks1, ks2) -> ks1.getLabel(locale).compareToIgnoreCase(ks2.getLabel(locale))).map(ks -> new ParameterOption(ks.getId(), ks.getLabel(locale))).collect(Collectors.toList());
            }
            if (CONFIG_DEFAULT_STT.equals(param)) {
                return this.sttServices.values().stream().sorted((stt1, stt2) -> stt1.getLabel(locale).compareToIgnoreCase(stt2.getLabel(locale))).map(stt -> new ParameterOption(stt.getId(), stt.getLabel(locale))).collect(Collectors.toList());
            }
            if (CONFIG_DEFAULT_TTS.equals(param)) {
                return this.ttsServices.values().stream().sorted((tts1, tts2) -> tts1.getLabel(locale).compareToIgnoreCase(tts2.getLabel(locale))).map(tts -> new ParameterOption(tts.getId(), tts.getLabel(locale))).collect(Collectors.toList());
            }
            if (CONFIG_DEFAULT_VOICE.equals(param)) {
                Locale nullSafeLocale = locale != null ? locale : this.localeProvider.getLocale();
                return this.getAllVoicesSorted(nullSafeLocale).stream().filter(v -> this.getTTS((Voice)v) != null).map(v -> new ParameterOption(v.getUID(), String.format("%s - %s - %s", this.getTTS((Voice)v).getLabel(nullSafeLocale), v.getLocale().getDisplayName(nullSafeLocale), v.getLabel()))).collect(Collectors.toList());
            }
        }
        return null;
    }
}

