/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.voice.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.voice.text.ASTNode;
import org.eclipse.smarthome.core.voice.text.Expression;
import org.eclipse.smarthome.core.voice.text.ExpressionAlternatives;
import org.eclipse.smarthome.core.voice.text.ExpressionCardinality;
import org.eclipse.smarthome.core.voice.text.ExpressionIdentifier;
import org.eclipse.smarthome.core.voice.text.ExpressionLet;
import org.eclipse.smarthome.core.voice.text.ExpressionMatch;
import org.eclipse.smarthome.core.voice.text.ExpressionSequence;
import org.eclipse.smarthome.core.voice.text.HumanLanguageInterpreter;
import org.eclipse.smarthome.core.voice.text.InterpretationException;
import org.eclipse.smarthome.core.voice.text.InterpretationResult;
import org.eclipse.smarthome.core.voice.text.Rule;
import org.eclipse.smarthome.core.voice.text.TokenList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuleBasedInterpreter
implements HumanLanguageInterpreter {
    private static final String JSGF = "JSGF";
    private static final Set<String> SUPPORTED_GRAMMERS = Collections.unmodifiableSet(Collections.singleton("JSGF"));
    private static final String OK = "ok";
    private static final String SORRY = "sorry";
    private static final String ERROR = "error";
    private static final String STATE_CURRENT = "state_current";
    private static final String STATE_ALREADY_SINGULAR = "state_already_singular";
    private static final String MULTIPLE_OBJECTS = "multiple_objects";
    private static final String NO_OBJECTS = "no_objects";
    private static final String COMMAND_NOT_ACCEPTED = "command_not_accepted";
    private static final String CMD = "cmd";
    private static final String NAME = "name";
    private static final String LANGUAGE_SUPPORT = "LanguageSupport";
    private Logger logger = LoggerFactory.getLogger(AbstractRuleBasedInterpreter.class);
    private HashMap<Locale, ArrayList<Rule>> languageRules;
    private HashMap<Locale, HashSet<String>> allItemTokens = null;
    private HashMap<Locale, HashMap<Item, ArrayList<HashSet<String>>>> itemTokens = null;
    private ItemRegistry itemRegistry;
    private EventPublisher eventPublisher;
    private RegistryChangeListener<Item> registryChangeListener = new RegistryChangeListener<Item>(){

        public void added(Item element) {
            AbstractRuleBasedInterpreter.this.invalidate();
        }

        public void removed(Item element) {
            AbstractRuleBasedInterpreter.this.invalidate();
        }

        public void updated(Item oldElement, Item element) {
            AbstractRuleBasedInterpreter.this.invalidate();
        }
    };

    protected abstract void createRules();

    @Override
    public String interpret(Locale locale, String text) throws InterpretationException {
        ResourceBundle language = ResourceBundle.getBundle(LANGUAGE_SUPPORT, locale);
        Rule[] rules = this.getRules(locale);
        if (language == null || rules.length == 0) {
            throw new InterpretationException(String.valueOf(locale.getDisplayLanguage(Locale.ENGLISH)) + " is not supported at the moment.");
        }
        TokenList tokens = new TokenList(this.tokenize(locale, text));
        if (tokens.eof()) {
            throw new InterpretationException(language.getString(SORRY));
        }
        InterpretationResult lastResult = null;
        Rule[] ruleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            InterpretationResult result = rule.execute(language, tokens);
            if (result.isSuccess()) {
                return result.getResponse();
            }
            if (result != InterpretationResult.SYNTAX_ERROR) {
                lastResult = result;
            }
            ++n2;
        }
        if (lastResult == null) {
            throw new InterpretationException(language.getString(SORRY));
        }
        throw lastResult.getException();
    }

    private void invalidate() {
        this.allItemTokens = null;
        this.itemTokens = null;
        this.languageRules = null;
    }

    HashSet<String> getAllItemTokens(Locale locale) {
        HashSet<String> localeTokens;
        if (this.allItemTokens == null) {
            this.allItemTokens = new HashMap();
        }
        if ((localeTokens = this.allItemTokens.get(locale)) == null) {
            localeTokens = new HashSet();
            this.allItemTokens.put(locale, localeTokens);
            for (Item item : this.itemRegistry.getAll()) {
                localeTokens.addAll(this.tokenize(locale, item.getLabel()));
            }
        }
        return localeTokens;
    }

    HashMap<Item, ArrayList<HashSet<String>>> getItemTokens(Locale locale) {
        HashMap<Object, ArrayList<HashSet<String>>> localeTokens;
        if (this.itemTokens == null) {
            this.itemTokens = new HashMap();
        }
        if ((localeTokens = this.itemTokens.get(locale)) == null) {
            localeTokens = new HashMap();
            this.itemTokens.put(locale, localeTokens);
            for (Item item : this.itemRegistry.getItems()) {
                if (!item.getGroupNames().isEmpty()) continue;
                this.addItem(locale, localeTokens, new HashSet<String>(), item);
            }
        }
        return localeTokens;
    }

    private void addItem(Locale locale, HashMap<Item, ArrayList<HashSet<String>>> target, HashSet<String> tokens, Item item) {
        HashSet<String> nt = new HashSet<String>(tokens);
        nt.addAll(this.tokenize(locale, item.getLabel()));
        ArrayList<HashSet<String>> list = target.get(item);
        if (list == null) {
            list = new ArrayList();
            target.put(item, list);
        }
        list.add(nt);
        if (item instanceof GroupItem) {
            for (Item member : ((GroupItem)item).getMembers()) {
                this.addItem(locale, target, nt, member);
            }
        }
    }

    protected Expression name() {
        return this.name(null);
    }

    protected Expression name(Expression stopper) {
        return this.tag(NAME, (Object)this.star(new ExpressionIdentifier(this, stopper)));
    }

    private HashMap<Locale, ArrayList<Rule>> getLanguageRules() {
        if (this.languageRules == null) {
            this.languageRules = new HashMap();
            this.createRules();
        }
        return this.languageRules;
    }

    public Rule[] getRules(Locale locale) {
        HashMap<Locale, ArrayList<Rule>> lr = this.getLanguageRules();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        HashSet<ArrayList<Rule>> ruleSets = new HashSet<ArrayList<Rule>>();
        ArrayList<Rule> ruleSet = lr.get(locale);
        if (ruleSet != null) {
            ruleSets.add(ruleSet);
            rules.addAll(ruleSet);
        }
        String l = locale.getLanguage();
        for (Locale rl : lr.keySet()) {
            if (!rl.getLanguage().equals(l) || ruleSets.contains(ruleSet = lr.get(rl))) continue;
            ruleSets.add(ruleSet);
            rules.addAll(ruleSet);
        }
        return rules.toArray(new Rule[0]);
    }

    protected void addRules(Locale locale, Rule ... rules) {
        ArrayList<Rule> ruleSet = this.languageRules.get(locale);
        if (ruleSet == null) {
            ruleSet = new ArrayList();
            this.languageRules.put(locale, ruleSet);
        }
        Rule[] ruleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            ruleSet.add(rule);
            ++n2;
        }
    }

    protected Rule itemRule(Object headExpression) {
        return this.itemRule(headExpression, null);
    }

    protected Rule itemRule(Object headExpression, Object tailExpression) {
        Expression tail = this.exp(tailExpression);
        ExpressionSequence expression = tail == null ? this.seq(headExpression, this.name()) : this.seq(headExpression, this.name(tail), tail);
        return new Rule(expression){

            @Override
            public InterpretationResult interpretAST(ResourceBundle language, ASTNode node) {
                String[] name = node.findValueAsStringArray(AbstractRuleBasedInterpreter.NAME);
                ASTNode cmdNode = node.findNode(AbstractRuleBasedInterpreter.CMD);
                Object tag = cmdNode.getTag();
                Object value = cmdNode.getValue();
                Object command = tag instanceof Command ? (Command)tag : (value instanceof Number ? new DecimalType(((Number)value).longValue()) : new StringType(cmdNode.getValueAsString()));
                if (name != null && command != null) {
                    try {
                        return new InterpretationResult(true, AbstractRuleBasedInterpreter.this.executeSingle(language, name, (Command)command));
                    }
                    catch (InterpretationException ex) {
                        return new InterpretationResult(ex);
                    }
                }
                return InterpretationResult.SEMANTIC_ERROR;
            }
        };
    }

    protected Expression exp(Object obj) {
        if (obj instanceof Expression) {
            return (Expression)obj;
        }
        return obj == null ? null : new ExpressionMatch(obj.toString());
    }

    protected Expression[] exps(Object ... objects) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        int i = 0;
        while (i < objects.length) {
            Expression e = this.exp(objects[i]);
            if (e != null) {
                result.add(e);
            }
            ++i;
        }
        return result.toArray(new Expression[0]);
    }

    protected Expression tag(String name, Object expression) {
        return this.tag(name, expression, null);
    }

    protected Expression tag(Object expression, Object tag) {
        return this.tag(null, expression, tag);
    }

    protected Expression tag(String name, Object expression, Object tag) {
        return new ExpressionLet(name, this.exp(expression), null, tag);
    }

    protected Expression cmd(Object expression) {
        return this.cmd(expression, null);
    }

    protected Expression cmd(Object expression, Command command) {
        return this.tag(CMD, expression, command);
    }

    protected ExpressionAlternatives alt(Object ... expressions) {
        return new ExpressionAlternatives(this.exps(expressions));
    }

    protected ExpressionSequence seq(Object ... expressions) {
        return new ExpressionSequence(this.exps(expressions));
    }

    protected ExpressionCardinality opt(Object expression) {
        return new ExpressionCardinality(this.exp(expression), false, true);
    }

    protected ExpressionCardinality star(Object expression) {
        return new ExpressionCardinality(this.exp(expression), false, false);
    }

    protected ExpressionCardinality plus(Object expression) {
        return new ExpressionCardinality(this.exp(expression), true, false);
    }

    protected String executeSingle(ResourceBundle language, String[] labelFragments, Command command) throws InterpretationException {
        Item item;
        block8: {
            ArrayList<Item> items = this.getMatchingItems(language, labelFragments, command.getClass());
            if (items.size() < 1) {
                if (this.getMatchingItems(language, labelFragments, null).size() >= 1) {
                    throw new InterpretationException(language.getString(COMMAND_NOT_ACCEPTED).replace("<cmd>", command.toString()));
                }
                throw new InterpretationException(language.getString(NO_OBJECTS));
            }
            if (items.size() > 1) {
                throw new InterpretationException(language.getString(MULTIPLE_OBJECTS));
            }
            item = items.get(0);
            if (command instanceof State) {
                try {
                    State newState = (State)command;
                    State oldState = item.getStateAs(newState.getClass());
                    if (!oldState.equals(newState)) break block8;
                    String template = language.getString(STATE_ALREADY_SINGULAR);
                    String cmdName = "state_" + command.toString().toLowerCase();
                    String stateText = null;
                    try {
                        stateText = language.getString(cmdName);
                    }
                    catch (Exception exception) {
                        stateText = language.getString(STATE_CURRENT);
                    }
                    return template.replace("<state>", stateText);
                }
                catch (Exception ex) {
                    this.logger.debug("Failed constructing response: {}", (Object)ex.getMessage());
                    return language.getString(ERROR);
                }
            }
        }
        this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)item.getName(), (Command)command));
        return language.getString(OK);
    }

    protected ArrayList<Item> getMatchingItems(ResourceBundle language, String[] labelFragments, Class<?> commandType) {
        ArrayList<Item> items = new ArrayList<Item>();
        HashMap<Item, ArrayList<HashSet<String>>> map = this.getItemTokens(language.getLocale());
        for (Item item : map.keySet()) {
            for (HashSet<String> parts : map.get(item)) {
                boolean allMatch = true;
                String[] stringArray = labelFragments;
                int n = labelFragments.length;
                int n2 = 0;
                while (n2 < n) {
                    String fragment = stringArray[n2];
                    if (!parts.contains(fragment.toLowerCase(language.getLocale()))) {
                        allMatch = false;
                        break;
                    }
                    ++n2;
                }
                if (!allMatch || commandType != null && !item.getAcceptedCommandTypes().contains(commandType)) continue;
                String name = item.getName();
                boolean insert = true;
                for (Item si : items) {
                    if (!name.startsWith(si.getName())) continue;
                    insert = false;
                }
                if (!insert) continue;
                int i = 0;
                while (i < items.size()) {
                    Item si = items.get(i);
                    if (si.getName().startsWith(name)) {
                        items.remove(i);
                        --i;
                    }
                    ++i;
                }
                items.add(item);
            }
        }
        return items;
    }

    protected ArrayList<String> tokenize(Locale locale, String text) {
        ArrayList<String> parts = new ArrayList<String>();
        if (text == null) {
            return parts;
        }
        String[] split = locale != null && locale.getLanguage().equalsIgnoreCase(Locale.FRENCH.getLanguage()) ? text.toLowerCase(locale).replaceAll("[\\']", " ").replaceAll("[^\\w\\s\u00e0\u00e2\u00e4\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u00f9\u00fb\u00fc]", " ").split("\\s") : text.toLowerCase(locale).replaceAll("[\\']", "").replaceAll("[^\\w\\s]", " ").split("\\s");
        int i = 0;
        while (i < split.length) {
            String part = split[i].trim();
            if (part.length() > 0) {
                parts.add(part);
            }
            ++i;
        }
        return parts;
    }

    @Override
    public Set<Locale> getSupportedLocales() {
        return Collections.unmodifiableSet(this.getLanguageRules().keySet());
    }

    @Override
    public Set<String> getSupportedGrammarFormats() {
        return SUPPORTED_GRAMMERS;
    }

    @Override
    public String getGrammar(Locale locale, String format) {
        if (!JSGF.equals(format)) {
            return null;
        }
        JSGFGenerator generator = new JSGFGenerator(ResourceBundle.getBundle(LANGUAGE_SUPPORT, locale));
        return generator.getGrammar();
    }

    public void setItemRegistry(ItemRegistry itemRegistry) {
        if (this.itemRegistry == null) {
            this.itemRegistry = itemRegistry;
            this.itemRegistry.addRegistryChangeListener(this.registryChangeListener);
        }
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        if (itemRegistry == this.itemRegistry) {
            this.itemRegistry.removeRegistryChangeListener(this.registryChangeListener);
            this.itemRegistry = null;
        }
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        if (this.eventPublisher == null) {
            this.eventPublisher = eventPublisher;
        }
    }

    public void unsetEventPublisher(EventPublisher eventPublisher) {
        if (eventPublisher == this.eventPublisher) {
            this.eventPublisher = null;
        }
    }

    private class JSGFGenerator {
        private ResourceBundle language;
        private HashMap<Expression, Integer> ids = new HashMap();
        private HashSet<Expression> exported = new HashSet();
        private HashSet<Expression> shared = new HashSet();
        private int counter = 0;
        private HashSet<String> identifierExcludes = new HashSet();
        private HashSet<String> identifiers = new HashSet();
        private StringBuilder builder = new StringBuilder();

        JSGFGenerator(ResourceBundle language) {
            this.language = language;
        }

        private void addChildren(Expression exp) {
            for (Expression se : exp.getChildExpressions()) {
                this.addExpression(se);
            }
        }

        private int addExpression(Expression exp) {
            if (this.ids.containsKey(exp)) {
                this.shared.add(exp);
                return this.ids.get(exp);
            }
            int id = this.counter++;
            this.ids.put(exp, id);
            this.addChildren(exp);
            return id;
        }

        private int addExportedExpression(Expression exp) {
            this.shared.add(exp);
            this.exported.add(exp);
            int id = this.addExpression(exp);
            return id;
        }

        private Expression unwrapLet(Expression expression) {
            Expression exp = expression;
            while (exp instanceof ExpressionLet) {
                exp = ((ExpressionLet)expression).getSubExpression();
            }
            return exp;
        }

        private void emit(Object obj) {
            this.builder.append(obj);
        }

        private void emitName(Expression expression) {
            this.emit("r");
            this.emit(this.ids.get(this.unwrapLet(expression)));
        }

        private void emitReference(Expression expression) {
            this.emit("<");
            this.emitName(expression);
            this.emit(">");
        }

        private void emitDefinition(Expression expression) {
            if (this.exported.contains(expression)) {
                this.emit("public ");
            }
            this.emit("<");
            this.emitName(expression);
            this.emit("> = ");
            this.emitExpression(expression);
            this.emit(";\n\n");
        }

        private void emitUse(Expression expression) {
            if (this.shared.contains(expression)) {
                this.emitReference(expression);
            } else {
                this.emitExpression(expression);
            }
        }

        private void emitExpression(Expression expression) {
            Expression unwrappedExpression = this.unwrapLet(expression);
            if (unwrappedExpression instanceof ExpressionMatch) {
                this.emitMatchExpression((ExpressionMatch)unwrappedExpression);
            } else if (unwrappedExpression instanceof ExpressionSequence) {
                this.emitSequenceExpression((ExpressionSequence)unwrappedExpression);
            } else if (unwrappedExpression instanceof ExpressionAlternatives) {
                this.emitAlternativesExpression((ExpressionAlternatives)unwrappedExpression);
            } else if (unwrappedExpression instanceof ExpressionCardinality) {
                this.emitCardinalExpression((ExpressionCardinality)unwrappedExpression);
            } else if (unwrappedExpression instanceof ExpressionIdentifier) {
                this.emitItemIdentifierExpression((ExpressionIdentifier)unwrappedExpression);
            }
        }

        private void emitMatchExpression(ExpressionMatch expression) {
            this.emit(expression.getPattern());
        }

        private void emitSequenceExpression(ExpressionSequence expression) {
            this.emitGroup(" ", expression.getChildExpressions());
        }

        private void emitAlternativesExpression(ExpressionAlternatives expression) {
            this.emitGroup(" | ", expression.getChildExpressions());
        }

        private void emitCardinalExpression(ExpressionCardinality expression) {
            if (!expression.isAtLeastOne() && !expression.isAtMostOne()) {
                this.emitUse(expression.getSubExpression());
                this.emit("*");
            } else if (expression.isAtLeastOne()) {
                this.emitUse(expression.getSubExpression());
                this.emit("+");
            } else if (expression.isAtMostOne()) {
                this.emit("[");
                this.emitUse(expression.getSubExpression());
                this.emit("]");
            } else {
                this.emitUse(expression.getSubExpression());
            }
        }

        private void emitItemIdentifierExpression(ExpressionIdentifier expression) {
            HashSet<Object> excludes;
            HashSet<String> remainder = new HashSet<String>(this.identifierExcludes);
            Expression stopper = expression.getStopper();
            HashSet<Object> hashSet = excludes = stopper == null ? new HashSet() : stopper.getFirsts(this.language);
            if (excludes.size() > 0) {
                remainder.removeAll(excludes);
                if (remainder.size() > 0) {
                    this.emit("(");
                }
                this.emit("<idbase>");
                for (String token : remainder) {
                    this.emit(" | ");
                    this.emit(token);
                }
                if (remainder.size() > 0) {
                    this.emit(")");
                }
            } else {
                this.emit("<idpart>");
            }
        }

        private void emitGroup(String separator, List<Expression> expressions) {
            int l = expressions.size();
            if (l > 0) {
                this.emit("(");
            }
            int i = 0;
            while (i < l) {
                if (i > 0) {
                    this.emit(separator);
                }
                this.emitUse(expressions.get(i));
                ++i;
            }
            if (l > 0) {
                this.emit(")");
            }
        }

        private void emitSet(HashSet<String> set, String separator) {
            boolean sep = false;
            for (String p : set) {
                if (sep) {
                    this.emit(separator);
                } else {
                    sep = true;
                }
                this.emit(p);
            }
        }

        String getGrammar() {
            Rule[] rules = AbstractRuleBasedInterpreter.this.getRules(this.language.getLocale());
            this.identifiers.addAll(AbstractRuleBasedInterpreter.this.getAllItemTokens(this.language.getLocale()));
            Rule[] ruleArray = rules;
            int n = rules.length;
            int n2 = 0;
            while (n2 < n) {
                Rule rule = ruleArray[n2];
                Expression e = rule.getExpression();
                this.addExportedExpression(e);
                ++n2;
            }
            for (Expression e : this.ids.keySet()) {
                Expression stopper;
                if (!(e instanceof ExpressionIdentifier) || (stopper = ((ExpressionIdentifier)e).getStopper()) == null) continue;
                this.identifierExcludes.addAll(stopper.getFirsts(this.language));
            }
            this.emit("#JSGF V1.0;\n\n");
            if (this.identifierExcludes.size() > 0) {
                HashSet<String> identifierBase = new HashSet<String>(this.identifiers);
                identifierBase.removeAll(this.identifierExcludes);
                this.emit("<idbase> = ");
                this.emitSet(identifierBase, " | ");
                this.emit(";\n\n<idpart> = <idbase> | ");
                this.emitSet(this.identifierExcludes, " | ");
                this.emit(";\n\n");
            } else {
                this.emit("<idpart> = ");
                this.emitSet(this.identifiers, " | ");
                this.emit(";\n\n");
            }
            for (Expression e : this.shared) {
                this.emitDefinition(e);
            }
            String grammar = this.builder.toString();
            return grammar;
        }
    }
}

