/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.voice.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.smarthome.core.voice.text.ASTNode;
import org.eclipse.smarthome.core.voice.text.Expression;
import org.eclipse.smarthome.core.voice.text.TokenList;

final class ExpressionAlternatives
extends Expression {
    private List<Expression> subExpressions;

    public ExpressionAlternatives(Expression ... subExpressions) {
        this.subExpressions = Collections.unmodifiableList(Arrays.asList(Arrays.copyOf(subExpressions, subExpressions.length)));
    }

    @Override
    ASTNode parse(ResourceBundle language, TokenList list) {
        ASTNode node = new ASTNode();
        int i = 0;
        while (i < this.subExpressions.size()) {
            ASTNode cr = this.subExpressions.get(i).parse(language, list);
            if (cr.isSuccess()) {
                node.setChildren(new ASTNode[]{cr});
                node.setRemainingTokens(cr.getRemainingTokens());
                node.setSuccess(true);
                node.setValue(cr.getValue());
                this.generateValue(node);
                return node;
            }
            ++i;
        }
        return node;
    }

    @Override
    List<Expression> getChildExpressions() {
        return this.subExpressions;
    }

    @Override
    boolean collectFirsts(ResourceBundle language, HashSet<String> firsts) {
        boolean blocking = true;
        for (Expression e : this.subExpressions) {
            boolean bl = blocking = blocking && e.collectFirsts(language, firsts);
        }
        return blocking;
    }

    public String toString() {
        String s = null;
        for (Expression e : this.subExpressions) {
            String string = s = s == null ? e.toString() : String.valueOf(s) + ", " + e.toString();
        }
        return "alt(" + s + ")";
    }
}

