/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.voice.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TokenList {
    private List<String> list = null;
    private int head = 0;
    private int tail = 0;

    public TokenList(List<String> list) {
        this.list = Collections.unmodifiableList(new ArrayList<String>(list));
        this.head = 0;
        this.tail = list.size() - 1;
    }

    private TokenList(List<String> list, int head, int tail) {
        this.list = list;
        this.head = head;
        this.tail = tail;
    }

    public String head() {
        return this.list.size() < 1 || this.head < 0 || this.head >= this.list.size() ? null : this.list.get(this.head);
    }

    public String tail() {
        return this.list.size() < 1 || this.tail < 0 || this.tail >= this.list.size() ? null : this.list.get(this.tail);
    }

    public boolean eof() {
        return this.head > this.tail;
    }

    public int size() {
        return this.tail - this.head + 1;
    }

    public boolean checkHead(String ... alternatives) {
        return this.check(this.head, alternatives);
    }

    public boolean checkTail(String ... alternatives) {
        return this.check(this.tail, alternatives);
    }

    public String peekHead(String ... alternatives) {
        return this.peek(this.head, alternatives);
    }

    public String peekTail(String ... alternatives) {
        return this.peek(this.tail, alternatives);
    }

    public TokenList skipHead() {
        return new TokenList(this.list, this.head + 1, this.tail);
    }

    public TokenList skipTail() {
        return new TokenList(this.list, this.head, this.tail - 1);
    }

    private String peek(int index, String ... alternatives) {
        return this.splice(index, alternatives);
    }

    private boolean check(int index, String ... alternatives) {
        return this.splice(index, alternatives) != null;
    }

    private String splice(int index, String ... alternatives) {
        if (index < this.head || index > this.tail || this.head > this.tail) {
            return null;
        }
        String token = this.list.get(index);
        if (alternatives.length == 0) {
            return token;
        }
        String[] stringArray = alternatives;
        int n = alternatives.length;
        int n2 = 0;
        while (n2 < n) {
            String alt = stringArray[n2];
            if (alt.equals(token)) {
                return token;
            }
            ++n2;
        }
        return null;
    }
}

