/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public abstract class AbstractUID {
    public static final String SEGMENT_PATTERN = "[A-Za-z0-9_-]*";
    public static final String SEPARATOR = ":";
    private final List<String> segments;

    public AbstractUID() {
        this.segments = Collections.emptyList();
    }

    public AbstractUID(String uid) {
        this(AbstractUID.splitToSegments(uid));
    }

    public AbstractUID(String ... segments) {
        this(Arrays.asList(segments));
    }

    public AbstractUID(List<String> segments) {
        int minNumberOfSegments = this.getMinimalNumberOfSegments();
        int numberOfSegments = segments.size();
        if (numberOfSegments < minNumberOfSegments) {
            throw new IllegalArgumentException(String.format("UID must have at least %d segments.", minNumberOfSegments));
        }
        int i = 0;
        while (i < numberOfSegments) {
            String segment = segments.get(i);
            this.validateSegment(segment, i, numberOfSegments);
            ++i;
        }
        this.segments = Collections.unmodifiableList(new ArrayList<String>(segments));
    }

    protected abstract int getMinimalNumberOfSegments();

    protected List<String> getAllSegments() {
        return this.segments;
    }

    protected String getSegment(int segment) {
        return this.segments.get(segment);
    }

    protected void validateSegment(String segment, int index, int length) {
        if (!segment.matches(SEGMENT_PATTERN)) {
            throw new IllegalArgumentException(String.format("ID segment '%s' contains invalid characters. Each segment of the ID must match the pattern %s.", segment, SEGMENT_PATTERN));
        }
    }

    public String toString() {
        return this.getAsString();
    }

    public String getAsString() {
        return String.join((CharSequence)SEPARATOR, this.segments);
    }

    private static List<String> splitToSegments(String id) {
        return Arrays.asList(id.split(SEPARATOR));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.segments.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractUID other = (AbstractUID)obj;
        return this.segments.equals(other.segments);
    }
}

