/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.common;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class ThreadFactoryBuilder {
    private static final String DEFAULT_NAME_PREFIX = "ESH";
    private @Nullable ThreadFactory wrappedThreadFactory;
    private @Nullable String name;
    private @Nullable String namePrefix = "ESH";
    private boolean daemonThreads;
    private @Nullable Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private @Nullable Integer priority;

    public static ThreadFactoryBuilder create() {
        return new ThreadFactoryBuilder();
    }

    private ThreadFactoryBuilder() {
    }

    public ThreadFactoryBuilder withWrappedThreadFactory(@Nullable ThreadFactory wrappedThreadFactory) {
        this.wrappedThreadFactory = wrappedThreadFactory;
        return this;
    }

    public ThreadFactoryBuilder withName(@Nullable String name) {
        this.name = name;
        return this;
    }

    public ThreadFactoryBuilder withNamePrefix(@Nullable String namePrefix) {
        this.namePrefix = namePrefix;
        return this;
    }

    public ThreadFactoryBuilder withDaemonThreads(boolean daemonThreads) {
        this.daemonThreads = daemonThreads;
        return this;
    }

    public ThreadFactoryBuilder withUncaughtExceptionHandler(@Nullable Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    public ThreadFactoryBuilder withPriority(@Nullable Integer priority) {
        if (priority != null && priority < 1) {
            throw new IllegalArgumentException(String.format("The provided priority %d is below the minimal thread priority %d", priority, 1));
        }
        if (priority != null && priority > 10) {
            throw new IllegalArgumentException(String.format("The provided priority %d is above the maximal thread priority %d", priority, 10));
        }
        this.priority = priority;
        return this;
    }

    public ThreadFactory build() {
        ThreadFactory wrappedThreadFactory = this.wrappedThreadFactory;
        if (wrappedThreadFactory == null) {
            wrappedThreadFactory = Executors.defaultThreadFactory();
        }
        return ThreadFactoryBuilder.build(wrappedThreadFactory, this.namePrefix, this.name, this.daemonThreads, this.uncaughtExceptionHandler, this.priority);
    }

    private static ThreadFactory build(final ThreadFactory wrappedThreadFactory, final @Nullable String namePrefix, final @Nullable String name, final boolean daemonThreads, final @Nullable Thread.UncaughtExceptionHandler uncaughtExceptionHandler, final @Nullable Integer priority) {
        return new ThreadFactory(){
            AtomicInteger threadCounter = new AtomicInteger(1);

            @Override
            public Thread newThread(@Nullable Runnable runnable) {
                Thread thread = wrappedThreadFactory.newThread(runnable);
                if (namePrefix != null && name != null) {
                    thread.setName(String.format("%s-%s-%d", namePrefix, name, this.threadCounter.getAndIncrement()));
                } else if (namePrefix != null && name == null) {
                    thread.setName(String.format("%s-%s", namePrefix, thread.getName()));
                } else if (namePrefix == null && name != null) {
                    thread.setName(String.format("%s-%d", name, this.threadCounter.getAndIncrement()));
                }
                thread.setDaemon(daemonThreads);
                if (uncaughtExceptionHandler != null) {
                    thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
                }
                if (priority != null) {
                    thread.setPriority(priority);
                }
                return thread;
            }
        };
    }
}

