/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.common;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.smarthome.core.common.QueueingThreadPoolExecutor;
import org.eclipse.smarthome.core.internal.common.WrappedScheduledExecutorService;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid="org.eclipse.smarthome.threadpool")
public class ThreadPoolManager {
    public static final String CONFIGURATION_PID = "org.eclipse.smarthome.threadpool";
    public static final String THREAD_POOL_NAME_COMMON = "common";
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolManager.class);
    protected static final int DEFAULT_THREAD_POOL_SIZE = 5;
    protected static final long THREAD_TIMEOUT = 65L;
    protected static final long THREAD_MONITOR_SLEEP = 60000L;
    protected static Map<String, ExecutorService> pools = new WeakHashMap<String, ExecutorService>();
    private static Map<String, Integer> configs = new ConcurrentHashMap<String, Integer>();

    protected void activate(Map<String, Object> properties) {
        this.modified(properties);
    }

    protected void modified(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (entry.getKey().equals("service.pid") || entry.getKey().equals("component.id") || entry.getKey().equals("component.name")) continue;
            String poolName = entry.getKey();
            Object config = entry.getValue();
            if (config == null) {
                configs.remove(poolName);
            }
            if (!(config instanceof String)) continue;
            try {
                Integer poolSize = Integer.valueOf((String)config);
                configs.put(poolName, poolSize);
                ThreadPoolExecutor pool = (ThreadPoolExecutor)pools.get(poolName);
                if (pool instanceof ScheduledThreadPoolExecutor) {
                    pool.setCorePoolSize(poolSize);
                    LOGGER.debug("Updated scheduled thread pool '{}' to size {}", new Object[]{poolName, poolSize});
                    continue;
                }
                if (!(pool instanceof QueueingThreadPoolExecutor)) continue;
                pool.setMaximumPoolSize(poolSize);
                LOGGER.debug("Updated queuing thread pool '{}' to size {}", new Object[]{poolName, poolSize});
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.warn("Ignoring invalid configuration for pool '{}': {} - value must be an integer", new Object[]{poolName, config});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledExecutorService getScheduledPool(String poolName) {
        ExecutorService pool = pools.get(poolName);
        if (pool == null) {
            Map<String, ExecutorService> map = pools;
            synchronized (map) {
                pool = pools.get(poolName);
                if (pool == null) {
                    int cfg = ThreadPoolManager.getConfig(poolName);
                    pool = new WrappedScheduledExecutorService(cfg, new NamedThreadFactory(poolName));
                    ((ThreadPoolExecutor)pool).setKeepAliveTime(65L, TimeUnit.SECONDS);
                    ((ThreadPoolExecutor)pool).allowCoreThreadTimeOut(true);
                    ((ScheduledThreadPoolExecutor)pool).setRemoveOnCancelPolicy(true);
                    pools.put(poolName, pool);
                    LOGGER.debug("Created scheduled thread pool '{}' of size {}", new Object[]{poolName, cfg});
                }
            }
        }
        if (pool instanceof ScheduledExecutorService) {
            return (ScheduledExecutorService)pool;
        }
        throw new IllegalArgumentException("Pool " + poolName + " is not a scheduled pool!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService getPool(String poolName) {
        ExecutorService pool = pools.get(poolName);
        if (pool == null) {
            Map<String, ExecutorService> map = pools;
            synchronized (map) {
                pool = pools.get(poolName);
                if (pool == null) {
                    int cfg = ThreadPoolManager.getConfig(poolName);
                    pool = QueueingThreadPoolExecutor.createInstance(poolName, cfg);
                    ((ThreadPoolExecutor)pool).setKeepAliveTime(65L, TimeUnit.SECONDS);
                    ((ThreadPoolExecutor)pool).allowCoreThreadTimeOut(true);
                    pools.put(poolName, pool);
                    LOGGER.debug("Created thread pool '{}' with size {}", new Object[]{poolName, cfg});
                }
            }
        }
        return pool;
    }

    protected static int getConfig(String poolName) {
        Integer cfg = configs.get(poolName);
        return cfg != null ? cfg : 5;
    }

    protected static class NamedThreadFactory
    implements ThreadFactory {
        protected final ThreadGroup group;
        protected final AtomicInteger threadNumber = new AtomicInteger(1);
        protected final String namePrefix;
        protected final String name;

        public NamedThreadFactory(String threadPool) {
            this.name = threadPool;
            this.namePrefix = "ESH-" + threadPool + "-";
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, String.valueOf(this.namePrefix) + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }

        public String getName() {
            return this.name;
        }
    }
}

