/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.extension;

import org.eclipse.smarthome.core.events.AbstractEvent;
import org.eclipse.smarthome.core.extension.ExtensionEventFactory;

public class ExtensionEvent
extends AbstractEvent {
    public static final String TYPE = ExtensionEvent.class.getSimpleName();
    private String msg;
    private String id;

    public ExtensionEvent(String topic, String payload, String id, String msg) {
        super(topic, payload, null);
        this.id = id;
        this.msg = msg;
    }

    public ExtensionEvent(String topic, String payload, String id) {
        this(topic, payload, id, null);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String toString() {
        if (this.getTopic().equals(ExtensionEventFactory.buildTopic("smarthome/extensions/{id}/installed", this.id))) {
            return "Extension '" + this.id + "' has been installed.";
        }
        if (this.getTopic().equals(ExtensionEventFactory.buildTopic("smarthome/extensions/{id}/uninstalled", this.id))) {
            return "Extension '" + this.id + "' has been uninstalled.";
        }
        return String.valueOf(this.id) + ": " + (this.msg != null ? this.msg : "Operation failed.");
    }
}

