/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.common;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappedScheduledExecutorService
extends ScheduledThreadPoolExecutor {
    final Logger logger = LoggerFactory.getLogger(WrappedScheduledExecutorService.class);

    public WrappedScheduledExecutorService(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        Future f;
        super.afterExecute(r, t);
        Throwable actualThrowable = t;
        if (actualThrowable == null && r instanceof Future && (f = (Future)((Object)r)).isDone()) {
            try {
                f.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException ee) {
                actualThrowable = ee.getCause();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (actualThrowable != null) {
            this.logger.warn("Scheduled runnable ended with an exception: ", actualThrowable);
        }
    }
}

