/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.scheduler;

import java.time.Duration;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.scheduler.SchedulerTemporalAdjuster;

@NonNullByDefault
class PeriodicAdjuster
implements SchedulerTemporalAdjuster {
    private final Iterator<Duration> iterator;
    private @Nullable Duration current;
    private @Nullable Temporal timeDone;

    PeriodicAdjuster(Duration ... delays) {
        this.iterator = Arrays.stream(delays).iterator();
    }

    @Override
    public boolean isDone(Temporal temporal) {
        return false;
    }

    @Override
    public Temporal adjustInto(@Nullable Temporal temporal) {
        Temporal nextTime;
        if (this.timeDone == null) {
            this.timeDone = temporal;
        }
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
        }
        this.timeDone = nextTime = this.timeDone.plus(this.current);
        return nextTime;
    }
}

