/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.scheduler;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.scheduler.ScheduledCompletableFuture;
import org.eclipse.smarthome.core.scheduler.Scheduler;
import org.eclipse.smarthome.core.scheduler.SchedulerRunnable;
import org.eclipse.smarthome.core.scheduler.SchedulerTemporalAdjuster;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SchedulerImpl.class}, immediate=true)
@NonNullByDefault
public class SchedulerImpl
implements Scheduler {
    private static final String SCHEDULER_THREAD_POOL = "scheduler";
    private final Logger logger = LoggerFactory.getLogger(SchedulerImpl.class);
    private final Clock clock = Clock.systemDefaultZone();
    private final ScheduledExecutorService executor = ThreadPoolManager.getScheduledPool("scheduler");

    @Override
    public ScheduledCompletableFuture<Instant> after(Duration duration) {
        Instant start = Instant.now();
        return this.after(() -> start, duration);
    }

    @Override
    public <T> ScheduledCompletableFuture<T> after(Callable<T> callable, Duration duration) {
        return this.afterInternal(new ScheduledCompletableFutureOnce(null, null), callable, duration);
    }

    private <T> ScheduledCompletableFutureOnce<T> afterInternal(ScheduledCompletableFutureOnce<T> deferred, Callable<T> callable, Duration duration) {
        ScheduledFuture<?> future = this.executor.schedule(() -> {
            try {
                deferred.complete(callable.call());
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                this.logger.warn("Scheduled job failed and stopped", (Throwable)e);
                deferred.completeExceptionally(e);
            }
        }, Math.max(0L, duration.toMillis()), TimeUnit.MILLISECONDS);
        deferred.setInstant(duration);
        deferred.exceptionally(e -> {
            if (e instanceof CancellationException) {
                future.cancel(true);
            }
            return null;
        });
        return deferred;
    }

    @Override
    public <T> ScheduledCompletableFuture<T> before(CompletableFuture<T> promise, Duration timeout) {
        AtomicBoolean done = new AtomicBoolean();
        Consumer<Runnable> runOnce = runnable -> {
            if (!done.getAndSet(true)) {
                runnable.run();
            }
        };
        ScheduledCompletableFutureOnce wrappedPromise = new ScheduledCompletableFutureOnce(null, null);
        Callable<Object> callable = () -> {
            wrappedPromise.completeExceptionally(new TimeoutException());
            return null;
        };
        ScheduledCompletableFutureOnce<Object> afterPromise = this.afterInternal(wrappedPromise, callable, timeout);
        wrappedPromise.exceptionally(e -> {
            if (e instanceof CancellationException) {
                afterPromise.cancel(true);
            }
            return null;
        });
        ((CompletableFuture)promise.thenAccept(p -> runOnce.accept(() -> {
            boolean bl = wrappedPromise.complete(p);
        }))).exceptionally(ex -> {
            runOnce.accept(() -> {
                boolean bl = wrappedPromise.completeExceptionally((Throwable)ex);
            });
            return null;
        });
        return wrappedPromise;
    }

    @Override
    public ScheduledCompletableFuture<Instant> at(Instant instant) {
        return this.at(() -> instant, instant);
    }

    @Override
    public <T> ScheduledCompletableFuture<T> at(Callable<T> callable, Instant instant) {
        return this.atInternal(new ScheduledCompletableFutureOnce(null, null), callable, instant);
    }

    private <T> ScheduledCompletableFuture<T> atInternal(ScheduledCompletableFutureOnce<T> deferred, Callable<T> callable, Instant instant) {
        long delay = instant.toEpochMilli() - System.currentTimeMillis();
        return this.afterInternal(deferred, callable, Duration.ofMillis(delay));
    }

    @Override
    public <T> ScheduledCompletableFuture<T> schedule(SchedulerRunnable runnable, SchedulerTemporalAdjuster temporalAdjuster) {
        ScheduledCompletableFutureRecurring schedule = new ScheduledCompletableFutureRecurring();
        this.schedule(schedule, runnable, temporalAdjuster);
        return schedule;
    }

    private <T> void schedule(ScheduledCompletableFutureRecurring<T> schedule, SchedulerRunnable runnable, SchedulerTemporalAdjuster temporalAdjuster) {
        ZonedDateTime newTime = ZonedDateTime.now(this.clock).with(temporalAdjuster);
        ScheduledCompletableFutureOnce deferred = new ScheduledCompletableFutureOnce(null, null);
        deferred.thenAccept(v -> {
            if (temporalAdjuster.isDone(newTime)) {
                schedule.complete(v);
            } else {
                this.schedule(schedule, runnable, temporalAdjuster);
            }
        });
        schedule.setScheduledPromise(deferred);
        this.atInternal(deferred, () -> {
            runnable.run();
            return null;
        }, Instant.from(newTime));
    }

    private static class ScheduledCompletableFutureOnce<T>
    extends CompletableFuture<T>
    implements ScheduledCompletableFuture<T> {
        private @Nullable Instant instant;

        private ScheduledCompletableFutureOnce() {
        }

        @Override
        public CompletableFuture<T> getPromise() {
            return this;
        }

        @Override
        public long getDelay(@Nullable TimeUnit timeUnit) {
            if (timeUnit == null || this.instant == null) {
                return 0L;
            }
            long remaining = this.instant.toEpochMilli() - System.currentTimeMillis();
            return timeUnit.convert(remaining, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(@Nullable Delayed timeUnit) {
            return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), timeUnit.getDelay(TimeUnit.MILLISECONDS));
        }

        protected void setInstant(Duration duration) {
            this.instant = Instant.now().plusMillis(duration.toMillis());
        }

        /* synthetic */ ScheduledCompletableFutureOnce(ScheduledCompletableFutureOnce scheduledCompletableFutureOnce, ScheduledCompletableFutureOnce scheduledCompletableFutureOnce2) {
            this();
        }
    }

    private static class ScheduledCompletableFutureRecurring<T>
    extends ScheduledCompletableFutureOnce<T> {
        private volatile @Nullable ScheduledCompletableFuture<T> scheduledPromise;

        public ScheduledCompletableFutureRecurring() {
            this.exceptionally((T e) -> {
                ScheduledCompletableFutureRecurring scheduledCompletableFutureRecurring = this;
                synchronized (scheduledCompletableFutureRecurring) {
                    if (e instanceof CancellationException && this.scheduledPromise != null) {
                        this.scheduledPromise.cancel(true);
                    }
                }
                return null;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setScheduledPromise(ScheduledCompletableFuture<T> future) {
            ScheduledCompletableFutureRecurring scheduledCompletableFutureRecurring = this;
            synchronized (scheduledCompletableFutureRecurring) {
                if (this.isCancelled()) {
                    future.cancel(true);
                } else {
                    this.scheduledPromise = future;
                    this.scheduledPromise.getPromise().exceptionally((T ex) -> {
                        this.completeExceptionally((Throwable)ex);
                        return null;
                    });
                }
            }
        }

        @Override
        public long getDelay(@Nullable TimeUnit timeUnit) {
            return this.scheduledPromise == null ? 0L : this.scheduledPromise.getDelay(timeUnit);
        }
    }
}

