/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public interface GroupFunction {
    public State calculate(Set<Item> var1);

    public <T extends State> T getStateAs(Set<Item> var1, Class<T> var2);

    public State[] getParameters();

    public static class Equality
    implements GroupFunction {
        @Override
        public State calculate(Set<Item> items) {
            if (items.size() > 0) {
                Iterator<Item> it = items.iterator();
                State state = it.next().getState();
                while (it.hasNext()) {
                    if (state.equals(it.next().getState())) continue;
                    return UnDefType.UNDEF;
                }
                return state;
            }
            return UnDefType.UNDEF;
        }

        @Override
        public <T extends State> T getStateAs(Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }
}

