/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.common.registry.Registry;
import org.eclipse.smarthome.core.internal.items.ItemBuilderImpl;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemBuilder;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemNotUniqueException;
import org.eclipse.smarthome.core.items.RegistryHook;
import org.eclipse.smarthome.core.library.CoreItemFactory;
import org.slf4j.LoggerFactory;

public interface ItemRegistry
extends Registry<Item, String> {
    public @NonNull Item getItem(String var1) throws ItemNotFoundException;

    public @NonNull Item getItemByPattern(@NonNull String var1) throws ItemNotFoundException, ItemNotUniqueException;

    public @NonNull Collection<@NonNull Item> getItems();

    public @NonNull Collection<Item> getItemsOfType(@NonNull String var1);

    public @NonNull Collection<@NonNull Item> getItems(@NonNull String var1);

    public @NonNull Collection<Item> getItemsByTag(String ... var1);

    public @NonNull Collection<Item> getItemsByTagAndType(@NonNull String var1, String ... var2);

    public <T extends Item> @NonNull Collection<T> getItemsByTag(@NonNull Class<T> var1, String ... var2);

    public @Nullable Item remove(@NonNull String var1, boolean var2);

    public void addRegistryHook(RegistryHook<Item> var1);

    public void removeRegistryHook(RegistryHook<Item> var1);

    @Deprecated
    default public ItemBuilder newItemBuilder(Item item) {
        LoggerFactory.getLogger(this.getClass()).warn("Deprecation: You are using a deprecated API. Please use the ItemBuilder OSGi service instead.");
        return new ItemBuilderImpl(Collections.singleton(new CoreItemFactory()), item);
    }

    @Deprecated
    default public ItemBuilder newItemBuilder(String itemType, String itemName) {
        LoggerFactory.getLogger(this.getClass()).warn("Deprecation: You are using a deprecated API. Please use the ItemBuilder OSGi service instead.");
        return new ItemBuilderImpl(Collections.singleton(new CoreItemFactory()), itemType, itemName);
    }
}

