/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.internal.service.BundleResolverImpl;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemStateConverter;
import org.eclipse.smarthome.core.types.State;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@NonNullByDefault
public class ItemUtil {
    public static final String EXTENSION_SEPARATOR = ":";

    private ItemUtil() {
    }

    public static boolean isValidItemName(String itemName) {
        return StringUtils.isNotEmpty((String)itemName) && itemName.matches("[a-zA-Z0-9_]*");
    }

    public static void assertValidItemName(String itemName) throws IllegalArgumentException {
        if (!ItemUtil.isValidItemName(itemName)) {
            throw new IllegalArgumentException("The specified name of the item '" + itemName + "' is not valid!");
        }
    }

    public static String getMainItemType(String itemTypeName) {
        Objects.requireNonNull(itemTypeName);
        if (itemTypeName.contains(EXTENSION_SEPARATOR)) {
            return itemTypeName.substring(0, itemTypeName.indexOf(EXTENSION_SEPARATOR));
        }
        return itemTypeName;
    }

    public static @Nullable String getItemTypeExtension(@Nullable String itemTypeName) {
        if (itemTypeName == null) {
            return null;
        }
        if (itemTypeName.contains(EXTENSION_SEPARATOR)) {
            return itemTypeName.substring(itemTypeName.indexOf(EXTENSION_SEPARATOR) + 1);
        }
        return null;
    }

    @Deprecated
    public static @Nullable State convertToAcceptedState(@Nullable State state, Item item) {
        BundleContext bundleContext = new BundleResolverImpl().resolveBundle(ItemUtil.class).getBundleContext();
        ServiceReference service = bundleContext.getServiceReference(ItemStateConverter.class);
        if (service == null) {
            return null;
        }
        ItemStateConverter itemStateConverter = (ItemStateConverter)bundleContext.getService(service);
        if (itemStateConverter == null) {
            return null;
        }
        return itemStateConverter.convertToAcceptedState(state, item);
    }
}

