/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.items.MetadataKey;

@NonNullByDefault
public final class Metadata
implements Identifiable<MetadataKey> {
    private final MetadataKey key;
    private final String value;
    private final Map<String, Object> configuration;

    public Metadata(MetadataKey key, String value, @Nullable Map<String, Object> configuration) {
        this.key = key;
        this.value = value;
        this.configuration = configuration != null ? Collections.unmodifiableMap(new HashMap<String, Object>(configuration)) : Collections.emptyMap();
    }

    @Override
    public MetadataKey getUID() {
        return this.key;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Metadata other = (Metadata)obj;
        return this.key.equals(other.key);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Metadata [key=");
        builder.append(this.key);
        builder.append(", value=");
        builder.append(this.value);
        builder.append(", configuration=");
        builder.append(Arrays.toString(this.configuration.entrySet().toArray()));
        builder.append("]");
        return builder.toString();
    }
}

