/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.TypeParser;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public class StringItem
extends GenericItem {
    private static List<Class<? extends State>> acceptedDataTypes = new ArrayList<Class<? extends State>>();
    private static List<Class<? extends Command>> acceptedCommandTypes = new ArrayList<Class<? extends Command>>();

    static {
        acceptedDataTypes.add(UnDefType.class);
        acceptedDataTypes.add(StringType.class);
        acceptedDataTypes.add(DateTimeType.class);
        acceptedCommandTypes.add(RefreshType.class);
        acceptedCommandTypes.add(StringType.class);
    }

    public StringItem(String name) {
        super("String", name);
    }

    public void send(StringType command) {
        this.internalSend(command);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return Collections.unmodifiableList(acceptedDataTypes);
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return Collections.unmodifiableList(acceptedCommandTypes);
    }

    @Override
    public <T extends State> @Nullable T getStateAs(Class<T> typeClass) {
        ArrayList<Class<? extends State>> list = new ArrayList<Class<? extends State>>();
        list.add(typeClass);
        State convertedState = TypeParser.parseState(list, this.state.toString());
        if (typeClass.isInstance(convertedState)) {
            return (T)((State)typeClass.cast(convertedState));
        }
        return super.getStateAs(typeClass);
    }

    @Override
    public void setState(State state) {
        if (this.isAcceptedState(acceptedDataTypes, state)) {
            super.setState(state);
        } else {
            this.logSetTypeError(state);
        }
    }
}

