/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.math.BigDecimal;
import java.util.IllegalFormatConversionException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.PrimitiveType;
import org.eclipse.smarthome.core.types.State;

@NonNullByDefault
public class DecimalType
extends Number
implements PrimitiveType,
State,
Command,
Comparable<DecimalType> {
    private static final long serialVersionUID = 4226845847123464690L;
    public static final DecimalType ZERO = new DecimalType(0L);
    protected BigDecimal value;

    public DecimalType() {
        this.value = BigDecimal.ZERO;
    }

    public DecimalType(BigDecimal value) {
        this.value = value;
    }

    public DecimalType(long value) {
        this.value = BigDecimal.valueOf(value);
    }

    public DecimalType(double value) {
        this.value = BigDecimal.valueOf(value);
    }

    public DecimalType(String value) {
        this.value = new BigDecimal(value);
    }

    public String toString() {
        return this.toFullString();
    }

    @Override
    public String toFullString() {
        return this.value.toPlainString();
    }

    public static DecimalType valueOf(String value) {
        return new DecimalType(value);
    }

    @Override
    public String format(String pattern) {
        try {
            return String.format(pattern, this.value.toBigIntegerExact());
        }
        catch (ArithmeticException arithmeticException) {
        }
        catch (IllegalFormatConversionException illegalFormatConversionException) {}
        return String.format(pattern, this.value);
    }

    public BigDecimal toBigDecimal() {
        return this.value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecimalType)) {
            return false;
        }
        DecimalType other = (DecimalType)obj;
        return !(this.value == null ? other.value != null : this.value.compareTo(other.value) != 0);
    }

    @Override
    public int compareTo(DecimalType o) {
        return this.value.compareTo(o.toBigDecimal());
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    protected <T extends State> @Nullable T defaultConversion(@Nullable Class<T> target) {
        return State.super.as(target);
    }

    @Override
    public <T extends State> @Nullable T as(@Nullable Class<T> target) {
        if (target == OnOffType.class) {
            return (T)((State)target.cast(this.equals(ZERO) ? OnOffType.OFF : OnOffType.ON));
        }
        if (target == PercentType.class) {
            return (T)((State)target.cast(new PercentType(this.toBigDecimal().multiply(BigDecimal.valueOf(100L)))));
        }
        if (target == UpDownType.class) {
            if (this.equals(ZERO)) {
                return (T)((State)target.cast(UpDownType.UP));
            }
            if (this.toBigDecimal().compareTo(BigDecimal.valueOf(1L)) == 0) {
                return (T)((State)target.cast(UpDownType.DOWN));
            }
            return null;
        }
        if (target == OpenClosedType.class) {
            if (this.equals(ZERO)) {
                return (T)((State)target.cast(OpenClosedType.CLOSED));
            }
            if (this.toBigDecimal().compareTo(BigDecimal.valueOf(1L)) == 0) {
                return (T)((State)target.cast(OpenClosedType.OPEN));
            }
            return null;
        }
        if (target == HSBType.class) {
            return (T)((State)target.cast(new HSBType(ZERO, PercentType.ZERO, new PercentType(this.toBigDecimal().multiply(BigDecimal.valueOf(100L))))));
        }
        return this.defaultConversion(target);
    }
}

