/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.ComplexType;
import org.eclipse.smarthome.core.types.PrimitiveType;
import org.eclipse.smarthome.core.types.State;

@NonNullByDefault
public class PointType
implements ComplexType,
Command,
State {
    public static final String LOCATION_PATTERN = "%2$s\u00b0N %3$s\u00b0E %1$sm";
    public static final double EARTH_GRAVITATIONAL_CONSTANT = 3.986004418E14;
    public static final double WGS84_A = 6378137.0;
    public static final String KEY_LATITUDE = "lat";
    public static final String KEY_LONGITUDE = "long";
    public static final String KEY_ALTITUDE = "alt";
    private static final BigDecimal CIRCLE = new BigDecimal(360);
    private static final BigDecimal FLAT = new BigDecimal(180);
    private static final BigDecimal RIGHT = new BigDecimal(90);
    private BigDecimal latitude = BigDecimal.ZERO;
    private BigDecimal longitude = BigDecimal.ZERO;
    private BigDecimal altitude = BigDecimal.ZERO;

    public PointType() {
    }

    public PointType(DecimalType latitude, DecimalType longitude) {
        this.canonicalize(latitude, longitude);
    }

    public PointType(DecimalType latitude, DecimalType longitude, DecimalType altitude) {
        this(latitude, longitude);
        this.setAltitude(altitude);
    }

    public PointType(StringType latitude, StringType longitude) {
        this(new DecimalType(latitude.toString()), new DecimalType(longitude.toString()));
    }

    public PointType(StringType latitude, StringType longitude, StringType altitude) {
        this(new DecimalType(latitude.toString()), new DecimalType(longitude.toString()), new DecimalType(altitude.toString()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PointType(String value) {
        if (value.isEmpty()) throw new IllegalArgumentException("Constructor argument must not be blank");
        List elements = Arrays.stream(value.split(",")).map(in -> in.trim()).collect(Collectors.toList());
        if (elements.size() < 2) throw new IllegalArgumentException(String.valueOf(value) + " is not a valid PointType syntax");
        this.canonicalize(new DecimalType((String)elements.get(0)), new DecimalType((String)elements.get(1)));
        if (elements.size() == 3) {
            this.setAltitude(new DecimalType((String)elements.get(2)));
            return;
        } else {
            if (elements.size() <= 3) return;
            throw new IllegalArgumentException(String.valueOf(value) + " is not a valid PointType syntax. The syntax must not consist of more than 3 elements.");
        }
    }

    public DecimalType getLatitude() {
        return new DecimalType(this.latitude);
    }

    public DecimalType getLongitude() {
        return new DecimalType(this.longitude);
    }

    public DecimalType getAltitude() {
        return new DecimalType(this.altitude);
    }

    public void setAltitude(DecimalType altitude) {
        this.altitude = altitude.toBigDecimal();
    }

    public DecimalType getGravity() {
        double latRad = Math.toRadians(this.latitude.doubleValue());
        double deltaG = -2000.0 * (this.altitude.doubleValue() / 1000.0) * 3.986004418E14 / Math.pow(6378137.0, 3.0);
        double sin2lat = Math.sin(latRad) * Math.sin(latRad);
        double sin22lat = Math.sin(2.0 * latRad) * Math.sin(2.0 * latRad);
        double result = 9.780327 * (1.0 + 0.0053024 * sin2lat - 5.8E-6 * sin22lat) + deltaG;
        return new DecimalType(result);
    }

    public DecimalType distanceFrom(PointType otherPoint) {
        double dLat = Math.toRadians(otherPoint.latitude.doubleValue() - this.latitude.doubleValue());
        double dLong = Math.toRadians(otherPoint.longitude.doubleValue() - this.longitude.doubleValue());
        double a = Math.pow(Math.sin(dLat / 2.0), 2.0) + Math.cos(Math.toRadians(this.latitude.doubleValue())) * Math.cos(Math.toRadians(otherPoint.latitude.doubleValue())) * Math.pow(Math.sin(dLong / 2.0), 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return new DecimalType(6378137.0 * c);
    }

    @Override
    public String format(@Nullable String pattern) {
        String formatPattern = pattern;
        if (formatPattern == null || "%s".equals(formatPattern)) {
            formatPattern = LOCATION_PATTERN;
        }
        return String.format(formatPattern, this.getConstituents().values().toArray());
    }

    public static PointType valueOf(String value) {
        return new PointType(value);
    }

    public String toString() {
        return this.toFullString();
    }

    @Override
    public String toFullString() {
        StringBuilder sb = new StringBuilder(this.latitude.toPlainString());
        sb.append(',');
        sb.append(this.longitude.toPlainString());
        if (!this.altitude.equals(BigDecimal.ZERO)) {
            sb.append(',');
            sb.append(this.altitude.toPlainString());
        }
        return sb.toString();
    }

    @Override
    public SortedMap<String, PrimitiveType> getConstituents() {
        TreeMap<String, PrimitiveType> result = new TreeMap<String, PrimitiveType>();
        result.put(KEY_LATITUDE, this.getLatitude());
        result.put(KEY_LONGITUDE, this.getLongitude());
        result.put(KEY_ALTITUDE, this.getAltitude());
        return result;
    }

    private void canonicalize(DecimalType aLat, DecimalType aLon) {
        this.latitude = FLAT.add(aLat.toBigDecimal()).remainder(CIRCLE);
        this.longitude = aLon.toBigDecimal();
        if (this.latitude.compareTo(BigDecimal.ZERO) == -1) {
            this.latitude = this.latitude.add(CIRCLE);
        }
        this.latitude = this.latitude.subtract(FLAT);
        if (this.latitude.compareTo(RIGHT) == 1) {
            this.latitude = FLAT.subtract(this.latitude);
            this.longitude = this.longitude.add(FLAT);
        } else if (this.latitude.compareTo(RIGHT.negate()) == -1) {
            this.latitude = FLAT.negate().subtract(this.latitude);
            this.longitude = this.longitude.add(FLAT);
        }
        this.longitude = FLAT.add(this.longitude).remainder(CIRCLE);
        if (this.longitude.compareTo(BigDecimal.ZERO) <= 0) {
            this.longitude = this.longitude.add(CIRCLE);
        }
        this.longitude = this.longitude.subtract(FLAT);
    }

    public int hashCode() {
        int tmp = 10000 * this.getLatitude().hashCode();
        tmp += 100 * this.getLongitude().hashCode();
        return tmp += this.getAltitude().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PointType)) {
            return false;
        }
        PointType other = (PointType)obj;
        return this.getLatitude().equals(other.getLatitude()) && this.getLongitude().equals(other.getLongitude()) && this.getAltitude().equals(other.getAltitude());
    }
}

