/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.types;

import java.math.BigDecimal;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.internal.types.StateDescriptionFragmentImpl;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateDescriptionFragment;
import org.eclipse.smarthome.core.types.StateOption;

@NonNullByDefault
public class StateDescriptionFragmentBuilder {
    private final StateDescriptionFragmentImpl fragment;

    private StateDescriptionFragmentBuilder() {
        this.fragment = new StateDescriptionFragmentImpl();
    }

    private StateDescriptionFragmentBuilder(StateDescription legacy) {
        this.fragment = new StateDescriptionFragmentImpl(legacy);
    }

    public static StateDescriptionFragmentBuilder create() {
        return new StateDescriptionFragmentBuilder();
    }

    public static StateDescriptionFragmentBuilder create(StateDescription legacy) {
        return new StateDescriptionFragmentBuilder(legacy);
    }

    public StateDescriptionFragment build() {
        return new StateDescriptionFragmentImpl(this.fragment);
    }

    public StateDescriptionFragmentBuilder withMaximum(BigDecimal maximum) {
        this.fragment.setMaximum(maximum);
        return this;
    }

    public StateDescriptionFragmentBuilder withMinimum(BigDecimal minimum) {
        this.fragment.setMinimum(minimum);
        return this;
    }

    public StateDescriptionFragmentBuilder withStep(BigDecimal step) {
        this.fragment.setStep(step);
        return this;
    }

    public StateDescriptionFragmentBuilder withPattern(String pattern) {
        this.fragment.setPattern(pattern);
        return this;
    }

    public StateDescriptionFragmentBuilder withReadOnly(Boolean readOnly) {
        this.fragment.setReadOnly(readOnly);
        return this;
    }

    public StateDescriptionFragmentBuilder withOptions(List<StateOption> options) {
        this.fragment.setOptions(options);
        return this;
    }
}

