/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.util;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class HexUtils {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private static final int ASCII_DIGITS_START_POSITION = 48;
    private static final int ASCII_UPPERCASE_LETTERS_START_POSITION = 65;

    private HexUtils() {
    }

    public static String bytesToHex(byte[] bytes, @Nullable CharSequence delimiter) {
        return Arrays.stream(HexUtils.toObjects(bytes)).map(b -> {
            int v = b & 0xFF;
            return "" + hexArray[v >>> 4] + hexArray[v & 0xF];
        }).collect(Collectors.joining(delimiter != null ? delimiter : ""));
    }

    public static String bytesToHex(byte[] bytes) {
        return HexUtils.bytesToHex(bytes, null);
    }

    private static Byte[] toObjects(byte[] bytes) {
        Byte[] bytesObjects = new Byte[bytes.length];
        Arrays.setAll(bytesObjects, n -> bytes[n]);
        return bytesObjects;
    }

    public static byte[] hexToBytes(String hexString, String delimiter) {
        String ucHexString = hexString.toUpperCase();
        Byte[] bytesObjects = (Byte[])Arrays.stream(ucHexString.split(delimiter)).map(s -> {
            if (s.length() != 2) {
                throw new IllegalArgumentException("hexString needs to have an even length: " + hexString);
            }
            return (byte)(HexUtils.hexCharacterToBin(s.charAt(0)) * 16 + HexUtils.hexCharacterToBin(s.charAt(1)));
        }).toArray(Byte[]::new);
        byte[] bytes = new byte[bytesObjects.length];
        int i = 0;
        while (i < bytesObjects.length) {
            bytes[i] = bytesObjects[i];
            ++i;
        }
        return bytes;
    }

    public static byte[] hexToBytes(String hexString) {
        return HexUtils.hexToBytes(hexString, "(?<=\\G.{2})");
    }

    private static byte hexCharacterToBin(char character) {
        if ('0' <= character && character <= '9') {
            return (byte)(character - 48);
        }
        if ('A' <= character && character <= 'F') {
            return (byte)(character - 65 + 10);
        }
        throw new IllegalArgumentException("hexString contains illegal character for hexToBytes: " + character);
    }
}

