/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.console.internal.extension;

import java.util.Collections;
import java.util.List;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemNotUniqueException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.TypeParser;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConsoleCommandExtension.class})
public class UpdateConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private ItemRegistry itemRegistry;
    private EventPublisher eventPublisher;

    public UpdateConsoleCommandExtension() {
        super("update", "Send a state update to an item.");
    }

    @Override
    public List<String> getUsages() {
        return Collections.singletonList(this.buildCommandUsage("<item> <state>", "sends a status update for an item"));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(String[] args, Console console) {
        block10: {
            if (args.length > 0) {
                itemName = args[0];
                try {
                    item = this.itemRegistry.getItemByPattern(itemName);
                    if (args.length > 1) {
                        stateName = args[1];
                        state = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)stateName);
                        if (state != null) {
                            this.eventPublisher.post((Event)ItemEventFactory.createStateEvent((String)item.getName(), (State)state));
                            console.println("Update has been sent successfully.");
                        } else {
                            console.println("Error: State '" + stateName + "' is not valid for item '" + itemName + "'");
                            console.print("Valid data types are: ( ");
                            for (Class acceptedType : item.getAcceptedDataTypes()) {
                                console.print(String.valueOf(acceptedType.getSimpleName()) + " ");
                            }
                            console.println(")");
                        }
                    } else {
                        this.printUsage(console);
                    }
                    break block10;
                }
                catch (ItemNotFoundException v0) {
                    console.println("Error: Item '" + itemName + "' does not exist.");
                    break block10;
                }
                catch (ItemNotUniqueException e) {
                    console.print("Error: Multiple items match this pattern: ");
                    ** for (item : e.getMatchingItems())
                }
lbl-1000:
                // 1 sources

                {
                    console.print(String.valueOf(item.getName()) + " ");
                    continue;
lbl29:
                    // 1 sources

                    break block10;
                }
            }
            this.printUsage(console);
        }
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }
}

