/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.javasound.internal;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.eclipse.smarthome.core.audio.AudioStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPlayer
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(AudioPlayer.class);
    private final AudioStream audioStream;

    public AudioPlayer(AudioStream audioStream) {
        this.audioStream = audioStream;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block16: {
            audioFormat = this.convertAudioFormat(this.audioStream.getFormat());
            if (audioFormat == null) {
                this.logger.warn("Audio format is unsupported or does not have enough details in order to be played");
                return;
            }
            info = new DataLine.Info(SourceDataLine.class, audioFormat);
            try {
                line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(audioFormat);
                break block16;
            }
            catch (Exception e) {
                this.logger.warn("No line found: {}", (Object)e.getMessage());
                this.logger.info("Available lines are:");
                mixerInfo = AudioSystem.getMixerInfo();
                mixer = null;
                cnt = 0;
                ** while (cnt < mixerInfo.length)
            }
lbl-1000:
            // 1 sources

            {
                mixer = AudioSystem.getMixer(mixerInfo[cnt]);
                var12_16 = lineInfos = mixer.getSourceLineInfo();
                var11_15 = lineInfos.length;
                var10_14 = 0;
                while (var10_14 < var11_15) {
                    lineInfo = var12_16[var10_14];
                    this.logger.info("{}", (Object)lineInfo);
                    ++var10_14;
                }
                ++cnt;
                continue;
            }
lbl28:
            // 1 sources

            return;
        }
        line.start();
        nRead = 0;
        abData = new byte[65532];
        try {
            try {
                while (-1 != nRead) {
                    nRead = this.audioStream.read(abData, 0, abData.length);
                    if (nRead < 0) continue;
                    line.write(abData, 0, nRead);
                }
            }
            catch (IOException e) {
                this.logger.error("Error while playing audio: {}", (Object)e.getMessage());
                line.drain();
                line.close();
                try {
                    this.audioStream.close();
                }
                catch (IOException v0) {}
                return;
            }
        }
        catch (Throwable var7_11) {
            line.drain();
            line.close();
            try {
                this.audioStream.close();
            }
            catch (IOException v1) {}
            throw var7_11;
        }
        line.drain();
        line.close();
        try {
            this.audioStream.close();
        }
        catch (IOException v2) {}
    }

    protected AudioFormat convertAudioFormat(org.eclipse.smarthome.core.audio.AudioFormat audioFormat) {
        AudioFormat.Encoding encoding = new AudioFormat.Encoding(audioFormat.getCodec());
        if (audioFormat.getCodec().equals("PCM_SIGNED")) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        } else if (audioFormat.getCodec().equals("ULAW")) {
            encoding = AudioFormat.Encoding.ULAW;
        } else if (audioFormat.getCodec().equals("ALAW")) {
            encoding = AudioFormat.Encoding.ALAW;
        }
        Long frequency = audioFormat.getFrequency();
        if (frequency == null) {
            return null;
        }
        float sampleRate = frequency.floatValue();
        Integer bitDepth = audioFormat.getBitDepth();
        if (bitDepth == null) {
            return null;
        }
        int sampleSizeInBits = bitDepth;
        int frameSize = sampleSizeInBits / 8;
        float frameRate = sampleRate / (float)frameSize;
        Boolean bigEndian = audioFormat.isBigEndian();
        if (bigEndian == null) {
            return null;
        }
        return new AudioFormat(encoding, sampleRate, sampleSizeInBits, 1, frameSize, frameRate, bigEndian);
    }
}

