/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.javasound.internal;

import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import org.eclipse.smarthome.core.audio.AudioException;
import org.eclipse.smarthome.core.audio.AudioSource;
import org.eclipse.smarthome.core.audio.AudioStream;
import org.eclipse.smarthome.io.javasound.internal.JavaSoundInputStream;
import org.osgi.service.component.annotations.Component;

@Component(service={AudioSource.class}, immediate=true)
public class JavaSoundAudioSource
implements AudioSource {
    private final AudioFormat format = new AudioFormat(16000.0f, 16, 1, true, false);
    private final org.eclipse.smarthome.core.audio.AudioFormat audioFormat = JavaSoundAudioSource.convertAudioFormat(this.format);
    private TargetDataLine microphone;

    private void initMicrophone(AudioFormat format) throws AudioException {
        try {
            TargetDataLine microphone = AudioSystem.getTargetDataLine(format);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
            microphone = (TargetDataLine)AudioSystem.getLine(info);
            microphone.open(format);
            this.microphone = microphone;
        }
        catch (Exception e) {
            throw new AudioException("Error creating the audio input stream.", (Throwable)e);
        }
    }

    public synchronized AudioStream getInputStream(org.eclipse.smarthome.core.audio.AudioFormat expectedFormat) throws AudioException {
        if (!expectedFormat.isCompatible(this.audioFormat)) {
            throw new AudioException("Cannot produce streams in format " + expectedFormat);
        }
        if (this.microphone == null) {
            this.initMicrophone(this.format);
        }
        return new JavaSoundInputStream(this.microphone, this.audioFormat);
    }

    public String toString() {
        return "javasound";
    }

    private static org.eclipse.smarthome.core.audio.AudioFormat convertAudioFormat(AudioFormat audioFormat) {
        String container = "WAVE";
        String codec = audioFormat.getEncoding().toString();
        Boolean bigEndian = new Boolean(audioFormat.isBigEndian());
        int frameSize = audioFormat.getFrameSize();
        int bitsPerFrame = frameSize * 8;
        Integer bitDepth = -1 == frameSize ? null : new Integer(bitsPerFrame);
        float frameRate = audioFormat.getFrameRate();
        Integer bitRate = -1.0f == frameRate ? null : new Integer((int)(frameRate * (float)bitsPerFrame));
        float sampleRate = audioFormat.getSampleRate();
        Long frequency = -1.0f == sampleRate ? null : new Long((long)sampleRate);
        return new org.eclipse.smarthome.core.audio.AudioFormat(container, codec, bigEndian, bitDepth, bitRate, frequency);
    }

    public String getId() {
        return "javasound";
    }

    public String getLabel(Locale locale) {
        return "System Microphone";
    }

    public Set<org.eclipse.smarthome.core.audio.AudioFormat> getSupportedFormats() {
        return Collections.singleton(this.audioFormat);
    }
}

