/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.mqttembeddedbroker.internal;

import io.moquette.server.Server;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class MqttEmbeddedBrokerDetectStart {
    protected @Nullable Server server;
    protected final MqttEmbeddedBrokerStartedListener startedListener;
    protected long startTime;
    protected int port;
    protected int timeout = 2000;
    protected @Nullable ScheduledExecutorService scheduler;
    protected @Nullable ScheduledFuture<?> schedule;

    public MqttEmbeddedBrokerDetectStart(MqttEmbeddedBrokerStartedListener startedListener) {
        this.startedListener = startedListener;
    }

    protected void servicePing() {
        ScheduledExecutorService scheduler = this.scheduler;
        if (scheduler == null) {
            return;
        }
        try {
            InetSocketAddress socketAddress = new InetSocketAddress("127.0.0.1", this.port);
            Socket socket = new Socket();
            socket.connect(socketAddress, 500);
            socket.close();
            this.schedule = null;
            this.startedListener.mqttEmbeddedBrokerStarted(false);
            return;
        }
        catch (IOException iOException) {
            if (System.currentTimeMillis() - this.startTime < (long)this.timeout) {
                this.schedule = scheduler.schedule(() -> this.servicePing(), 100L, TimeUnit.MILLISECONDS);
            } else {
                this.startedListener.mqttEmbeddedBrokerStarted(true);
            }
            return;
        }
    }

    public void startBrokerStartedDetection(int port, ScheduledExecutorService scheduler) {
        this.port = port;
        this.scheduler = scheduler;
        this.startTime = System.currentTimeMillis();
        this.schedule = null;
        this.servicePing();
    }

    public void stopBrokerStartDetection() {
        if (this.schedule != null) {
            this.schedule.cancel(true);
            this.schedule = null;
        }
    }

    public static interface MqttEmbeddedBrokerStartedListener {
        public void mqttEmbeddedBrokerStarted(boolean var1);
    }
}

