/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.config;

import java.io.IOException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ConfigurationService.class})
public class ConfigurationService {
    private ConfigurationAdmin configurationAdmin;
    private final Logger logger = LoggerFactory.getLogger(ConfigurationService.class);

    public org.eclipse.smarthome.config.core.Configuration get(String configId) throws IOException {
        Configuration configuration = this.configurationAdmin.getConfiguration(configId, null);
        Dictionary properties = configuration.getProperties();
        return this.toConfiguration(properties);
    }

    public org.eclipse.smarthome.config.core.Configuration update(String configId, org.eclipse.smarthome.config.core.Configuration newConfiguration) throws IOException {
        return this.update(configId, newConfiguration, false);
    }

    public String getProperty(String servicePID, String key) {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration(servicePID, null);
            if (configuration != null && configuration.getProperties() != null) {
                return (String)configuration.getProperties().get(key);
            }
        }
        catch (IOException iOException) {
            this.logger.debug("Error while retrieving property {} for PID {}.", (Object)key, (Object)servicePID);
        }
        return null;
    }

    public org.eclipse.smarthome.config.core.Configuration update(String configId, org.eclipse.smarthome.config.core.Configuration newConfiguration, boolean override) throws IOException {
        Configuration configuration = null;
        if (newConfiguration.containsKey("esh.servicecontext")) {
            try {
                configuration = this.getConfigurationWithContext(configId);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                this.logger.error("Failed to lookup config for PID '{}'", (Object)configId);
            }
            if (configuration == null) {
                configuration = this.configurationAdmin.createFactoryConfiguration(configId, null);
            }
        } else {
            configuration = this.configurationAdmin.getConfiguration(configId, null);
        }
        org.eclipse.smarthome.config.core.Configuration oldConfiguration = this.toConfiguration(configuration.getProperties());
        Dictionary<String, Object> properties = this.getProperties(configuration);
        Set configurationParameters = newConfiguration.getProperties().entrySet();
        if (override) {
            Set keySet = oldConfiguration.keySet();
            for (String key : keySet) {
                properties.remove(key);
            }
        }
        for (Map.Entry configurationParameter : configurationParameters) {
            Object value = configurationParameter.getValue();
            if (value == null) {
                properties.remove(configurationParameter.getKey());
                continue;
            }
            if (value instanceof String || value instanceof Integer || value instanceof Boolean || value instanceof Object[] || value instanceof Collection) {
                properties.put((String)configurationParameter.getKey(), value);
                continue;
            }
            properties.put((String)configurationParameter.getKey(), value.toString());
        }
        configuration.update(properties);
        return oldConfiguration;
    }

    private Configuration getConfigurationWithContext(String serviceId) throws IOException, InvalidSyntaxException {
        Configuration[] configs = this.configurationAdmin.listConfigurations("(&(service.pid=" + serviceId + "))");
        if (configs == null) {
            return null;
        }
        if (configs.length > 1) {
            throw new IllegalStateException("More than one configuration with PID " + serviceId + " exists");
        }
        return configs[0];
    }

    public org.eclipse.smarthome.config.core.Configuration delete(String configId) throws IOException {
        Configuration serviceConfiguration = this.configurationAdmin.getConfiguration(configId, null);
        org.eclipse.smarthome.config.core.Configuration oldConfiguration = this.toConfiguration(serviceConfiguration.getProperties());
        serviceConfiguration.delete();
        return oldConfiguration;
    }

    private org.eclipse.smarthome.config.core.Configuration toConfiguration(Dictionary<String, Object> dictionary) {
        if (dictionary == null) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(dictionary.size());
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key.equals("service.pid")) continue;
            properties.put(key, dictionary.get(key));
        }
        return new org.eclipse.smarthome.config.core.Configuration(properties);
    }

    private Dictionary<String, Object> getProperties(Configuration configuration) {
        Dictionary properties = configuration.getProperties();
        return properties != null ? properties : new Hashtable();
    }

    @Reference
    protected void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

