/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.internal.config;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTO;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTOMapper;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.LocaleService;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.Stream2JSONInputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Path(value="config-descriptions")
@RolesAllowed(value={"administrator"})
@Api(value="config-descriptions")
@Component
public class ConfigDescriptionResource
implements RESTResource {
    public static final String PATH_CONFIG_DESCRIPTIONS = "config-descriptions";
    private ConfigDescriptionRegistry configDescriptionRegistry;
    private LocaleService localeService;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setLocaleService(LocaleService localeService) {
        this.localeService = localeService;
    }

    protected void unsetLocaleService(LocaleService localeService) {
        this.localeService = null;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets all available config descriptions.", response=ConfigDescriptionDTO.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ConfigDescriptionDTO.class, responseContainer="List")})
    public Response getAll(@HeaderParam(value="Accept-Language") @ApiParam(value="Accept-Language") String language, @QueryParam(value="scheme") @ApiParam(value="scheme filter", required=false) @Nullable String scheme) {
        Locale locale = this.localeService.getLocale(language);
        Collection configDescriptions = this.configDescriptionRegistry.getConfigDescriptions(locale);
        return Response.ok((Object)new Stream2JSONInputStream(configDescriptions.stream().filter(configDescription -> scheme == null || scheme.equals(configDescription.getUID().getScheme())).map(ConfigDescriptionDTOMapper::map))).build();
    }

    @GET
    @Path(value="/{uri}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a config description by URI.", response=ConfigDescriptionDTO.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ConfigDescriptionDTO.class), @ApiResponse(code=400, message="Invalid URI syntax"), @ApiResponse(code=404, message="Not found")})
    public Response getByURI(@HeaderParam(value="Accept-Language") @ApiParam(value="Accept-Language") String language, @PathParam(value="uri") @ApiParam(value="uri") String uri) {
        Locale locale = this.localeService.getLocale(language);
        URI uriObject = UriBuilder.fromPath((String)uri).build(new Object[0]);
        ConfigDescription configDescription = this.configDescriptionRegistry.getConfigDescription(uriObject, locale);
        return configDescription != null ? Response.ok((Object)ConfigDescriptionDTOMapper.map((ConfigDescription)configDescription)).build() : JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)("Configuration not found: " + uri));
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = null;
    }

    public boolean isSatisfied() {
        return this.configDescriptionRegistry != null && this.localeService != null;
    }
}

