/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.internal.item;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.core.items.MetadataRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MetadataSelectorMatcher.class})
public class MetadataSelectorMatcher {
    private static final String METADATA_SCHEME = "metadata";
    private static final String METADATA_SCHEME_PREFIX = "metadata:";
    private MetadataRegistry metadataRegistry;
    private ConfigDescriptionRegistry configDescriptionRegistry;

    public Set<String> filterNamespaces(String namespaceSelector, Locale locale) {
        if (namespaceSelector == null || namespaceSelector.isEmpty()) {
            return Collections.emptySet();
        }
        Set originalNamespaces = Arrays.stream(namespaceSelector.split(",")).filter(n -> !this.metadataRegistry.isInternalNamespace(n)).map(n -> n.trim()).collect(Collectors.toSet());
        String namespacePattern = originalNamespaces.stream().collect(Collectors.joining("|"));
        Pattern pattern = Pattern.compile("metadata:(" + namespacePattern + ")$");
        Collection configDescriptions = this.configDescriptionRegistry.getConfigDescriptions(locale);
        Set configNamespaces = configDescriptions.stream().filter(cd -> cd.getUID().getScheme().equals(METADATA_SCHEME)).map(cd -> cd.getUID().toString()).filter(pattern.asPredicate()).map(uri -> uri.substring(METADATA_SCHEME_PREFIX.length())).collect(Collectors.toSet());
        HashSet result = new HashSet(originalNamespaces);
        result.addAll(configNamespaces);
        return result.stream().filter(namespace -> namespace.matches("[A-Za-z0-9_-]*")).collect(Collectors.toSet());
    }

    @Reference
    protected void setMetadataRegistry(MetadataRegistry metadataRegistry) {
        this.metadataRegistry = metadataRegistry;
    }

    protected void unsetMetadataRegistry(MetadataRegistry metadataRegistry) {
        this.metadataRegistry = null;
    }

    @Reference
    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = null;
    }
}

