/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.internal.thing;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTO;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTOMapper;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.dto.ChannelDefinitionDTO;
import org.eclipse.smarthome.core.thing.dto.ChannelGroupDefinitionDTO;
import org.eclipse.smarthome.core.thing.dto.StrippedThingTypeDTO;
import org.eclipse.smarthome.core.thing.dto.StrippedThingTypeDTOMapper;
import org.eclipse.smarthome.core.thing.dto.ThingTypeDTO;
import org.eclipse.smarthome.core.thing.type.BridgeType;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.eclipse.smarthome.io.rest.LocaleService;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.Stream2JSONInputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="thing-types")
@Api(value="thing-types")
@Component
public class ThingTypeResource
implements RESTResource {
    public static final String PATH_THINGS_TYPES = "thing-types";
    private final Logger logger = LoggerFactory.getLogger(ThingTypeResource.class);
    private ThingTypeRegistry thingTypeRegistry;
    private ConfigDescriptionRegistry configDescriptionRegistry;
    private ChannelTypeRegistry channelTypeRegistry;
    private ChannelGroupTypeRegistry channelGroupTypeRegistry;
    private LocaleService localeService;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
    }

    protected void unsetChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setChannelGroupTypeRegistry(ChannelGroupTypeRegistry channelGroupTypeRegistry) {
        this.channelGroupTypeRegistry = channelGroupTypeRegistry;
    }

    protected void unsetChannelGroupTypeRegistry(ChannelGroupTypeRegistry channelGroupTypeRegistry) {
        this.channelGroupTypeRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setLocaleService(LocaleService localeService) {
        this.localeService = localeService;
    }

    protected void unsetLocaleService(LocaleService localeService) {
        this.localeService = null;
    }

    @GET
    @RolesAllowed(value={"user"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets all available thing types without config description, channels and properties.", response=StrippedThingTypeDTO.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=StrippedThingTypeDTO.class, responseContainer="Set")})
    public Response getAll(@HeaderParam(value="Accept-Language") @ApiParam(value="Accept-Language") String language) {
        Locale locale = this.localeService.getLocale(language);
        Stream<StrippedThingTypeDTO> typeStream = this.thingTypeRegistry.getThingTypes(locale).stream().map(t -> this.convertToStrippedThingTypeDTO((ThingType)t, locale));
        return Response.ok((Object)new Stream2JSONInputStream(typeStream)).build();
    }

    @GET
    @RolesAllowed(value={"user"})
    @Path(value="/{thingTypeUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets thing type by UID.", response=ThingTypeDTO.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Thing type with provided thingTypeUID does not exist.", response=ThingTypeDTO.class), @ApiResponse(code=404, message="No content")})
    public Response getByUID(@PathParam(value="thingTypeUID") @ApiParam(value="thingTypeUID") String thingTypeUID, @HeaderParam(value="Accept-Language") @ApiParam(value="Accept-Language") String language) {
        Locale locale = this.localeService.getLocale(language);
        ThingType thingType = this.thingTypeRegistry.getThingType(new ThingTypeUID(thingTypeUID), locale);
        if (thingType != null) {
            return Response.ok((Object)this.convertToThingTypeDTO(thingType, locale)).build();
        }
        return Response.noContent().build();
    }

    private ThingTypeDTO convertToThingTypeDTO(ThingType thingType, Locale locale) {
        ArrayList parameterGroups;
        List parameters;
        ConfigDescription configDescription = thingType.getConfigDescriptionURI() != null ? this.configDescriptionRegistry.getConfigDescription(thingType.getConfigDescriptionURI(), locale) : null;
        if (configDescription != null) {
            ConfigDescriptionDTO configDescriptionDTO = ConfigDescriptionDTOMapper.map(configDescription);
            parameters = configDescriptionDTO.parameters;
            parameterGroups = configDescriptionDTO.parameterGroups;
        } else {
            parameters = new ArrayList(0);
            parameterGroups = new ArrayList(0);
        }
        List<ChannelDefinitionDTO> channelDefinitions = this.convertToChannelDefinitionDTOs(thingType.getChannelDefinitions(), locale);
        if (channelDefinitions == null) {
            return null;
        }
        return new ThingTypeDTO(thingType.getUID().toString(), thingType.getLabel(), thingType.getDescription(), thingType.getCategory(), thingType.isListed(), parameters, channelDefinitions, this.convertToChannelGroupDefinitionDTOs(thingType.getChannelGroupDefinitions(), locale), thingType.getSupportedBridgeTypeUIDs(), thingType.getProperties(), thingType instanceof BridgeType, parameterGroups, thingType.getExtensibleChannelTypeIds());
    }

    private List<ChannelGroupDefinitionDTO> convertToChannelGroupDefinitionDTOs(List<ChannelGroupDefinition> channelGroupDefinitions, Locale locale) {
        ArrayList<ChannelGroupDefinitionDTO> channelGroupDefinitionDTOs = new ArrayList<ChannelGroupDefinitionDTO>();
        for (ChannelGroupDefinition channelGroupDefinition : channelGroupDefinitions) {
            String description;
            String id = channelGroupDefinition.getId();
            ChannelGroupType channelGroupType = this.channelGroupTypeRegistry.getChannelGroupType(channelGroupDefinition.getTypeUID(), locale);
            String label = channelGroupDefinition.getLabel();
            if (label == null) {
                label = channelGroupType.getLabel();
            }
            if ((description = channelGroupDefinition.getDescription()) == null) {
                description = channelGroupType.getDescription();
            }
            List channelDefinitions = channelGroupType.getChannelDefinitions();
            List<ChannelDefinitionDTO> channelDefinitionDTOs = this.convertToChannelDefinitionDTOs(channelDefinitions, locale);
            channelGroupDefinitionDTOs.add(new ChannelGroupDefinitionDTO(id, label, description, channelDefinitionDTOs));
        }
        return channelGroupDefinitionDTOs;
    }

    private List<ChannelDefinitionDTO> convertToChannelDefinitionDTOs(List<ChannelDefinition> channelDefinitions, Locale locale) {
        ArrayList<ChannelDefinitionDTO> channelDefinitionDTOs = new ArrayList<ChannelDefinitionDTO>();
        for (ChannelDefinition channelDefinition : channelDefinitions) {
            String description;
            ChannelType channelType = this.channelTypeRegistry.getChannelType(channelDefinition.getChannelTypeUID(), locale);
            if (channelType == null) {
                this.logger.warn("Cannot find channel type: {}", (Object)channelDefinition.getChannelTypeUID());
                return null;
            }
            String label = channelDefinition.getLabel();
            if (label == null) {
                label = channelType.getLabel();
            }
            if ((description = channelDefinition.getDescription()) == null) {
                description = channelType.getDescription();
            }
            ChannelDefinitionDTO channelDefinitionDTO = new ChannelDefinitionDTO(channelDefinition.getId(), channelDefinition.getChannelTypeUID().toString(), label, description, channelType.getTags(), channelType.getCategory(), channelType.getState(), channelType.isAdvanced(), channelDefinition.getProperties());
            channelDefinitionDTOs.add(channelDefinitionDTO);
        }
        return channelDefinitionDTOs;
    }

    private StrippedThingTypeDTO convertToStrippedThingTypeDTO(ThingType thingType, Locale locale) {
        StrippedThingTypeDTO strippedThingTypeDTO = StrippedThingTypeDTOMapper.map((ThingType)thingType, (Locale)locale);
        if (strippedThingTypeDTO != null) {
            return strippedThingTypeDTO;
        }
        this.logger.warn("Cannot create DTO for thingType '{}'. Skip it.", (Object)thingType);
        return null;
    }

    public boolean isSatisfied() {
        return this.thingTypeRegistry != null && this.configDescriptionRegistry != null && this.channelTypeRegistry != null && this.channelGroupTypeRegistry != null && this.localeService != null;
    }
}

