/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.sitemap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFilter;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.events.ItemStatePredictedEvent;
import org.eclipse.smarthome.io.rest.sitemap.internal.PageChangeListener;
import org.eclipse.smarthome.io.rest.sitemap.internal.SitemapEvent;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapProvider;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SitemapSubscriptionService.class, EventSubscriber.class}, configurationPid="org.eclipse.smarthome.sitemapsubscription")
public class SitemapSubscriptionService
implements ModelRepositoryChangeListener,
EventSubscriber {
    private static final String SITEMAP_PAGE_SEPARATOR = "#";
    private static final String SITEMAP_SUFFIX = ".sitemap";
    private static final int DEFAULT_MAX_SUBSCRIPTIONS = 50;
    private final Logger logger = LoggerFactory.getLogger(SitemapSubscriptionService.class);
    private ItemUIRegistry itemUIRegistry;
    private final List<SitemapProvider> sitemapProviders = new ArrayList<SitemapProvider>();
    private final Map<String, String> pageOfSubscription = new ConcurrentHashMap<String, String>();
    private final Map<String, SitemapSubscriptionCallback> callbacks = new ConcurrentHashMap<String, SitemapSubscriptionCallback>();
    private final Map<String, Long> creationDates = new ConcurrentHashMap<String, Long>();
    private final Map<String, PageChangeListener> pageChangeListeners = new ConcurrentHashMap<String, PageChangeListener>();
    private int maxSubscriptions = 50;

    @Activate
    protected void activate(Map<String, Object> config) {
        this.applyConfig(config);
    }

    @Deactivate
    protected void deactivate() {
        this.pageOfSubscription.clear();
        this.callbacks.clear();
        for (PageChangeListener listener : this.pageChangeListeners.values()) {
            listener.dispose();
        }
        this.pageChangeListeners.clear();
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        this.applyConfig(config);
    }

    private void applyConfig(Map<String, Object> config) {
        if (config == null) {
            return;
        }
        String max = Objects.toString(config.get("maxSubscriptions"), null);
        if (max != null) {
            try {
                this.maxSubscriptions = Integer.parseInt(max);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.debug("Setting 'maxSubscriptions' must be a number; value '{}' ignored.", (Object)max);
            }
        }
    }

    @Reference
    protected void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    protected void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.add(provider);
        provider.addModelChangeListener((ModelRepositoryChangeListener)this);
    }

    protected void removeSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.remove(provider);
        provider.removeModelChangeListener((ModelRepositoryChangeListener)this);
    }

    public String createSubscription(SitemapSubscriptionCallback callback) {
        if (this.maxSubscriptions >= 0 && this.callbacks.size() >= this.maxSubscriptions) {
            this.logger.debug("No new subscription delivered as limit ({}) is already reached", (Object)this.maxSubscriptions);
            return null;
        }
        String subscriptionId = UUID.randomUUID().toString();
        this.callbacks.put(subscriptionId, callback);
        this.creationDates.put(subscriptionId, System.currentTimeMillis());
        this.logger.debug("Created new subscription with id {} ({} active subscriptions for a max of {})", new Object[]{subscriptionId, this.callbacks.size(), this.maxSubscriptions});
        return subscriptionId;
    }

    public void removeSubscription(String subscriptionId) {
        PageChangeListener listener;
        this.creationDates.remove(subscriptionId);
        this.callbacks.remove(subscriptionId);
        String sitemapPage = this.pageOfSubscription.remove(subscriptionId);
        if (sitemapPage != null && !this.pageOfSubscription.values().contains(sitemapPage) && (listener = this.pageChangeListeners.remove(sitemapPage)) != null) {
            listener.dispose();
        }
        this.logger.debug("Removed subscription with id {} ({} active subscriptions)", (Object)subscriptionId, (Object)this.callbacks.size());
    }

    public boolean exists(String subscriptionId) {
        return this.callbacks.containsKey(subscriptionId);
    }

    public String getPageId(String subscriptionId) {
        String sitemapWithPageId = this.pageOfSubscription.get(subscriptionId);
        return sitemapWithPageId == null ? null : this.extractPageId(sitemapWithPageId);
    }

    public String getSitemapName(String subscriptionId) {
        String sitemapWithPageId = this.pageOfSubscription.get(subscriptionId);
        return sitemapWithPageId == null ? null : this.extractSitemapName(sitemapWithPageId);
    }

    private String extractSitemapName(String sitemapWithPageId) {
        return sitemapWithPageId.split(SITEMAP_PAGE_SEPARATOR)[0];
    }

    private String extractPageId(String sitemapWithPageId) {
        return sitemapWithPageId.split(SITEMAP_PAGE_SEPARATOR)[1];
    }

    public void setPageId(String subscriptionId, String sitemapName, String pageId) {
        SitemapSubscriptionCallback callback = this.callbacks.get(subscriptionId);
        if (callback != null) {
            String oldSitemapPage = this.pageOfSubscription.remove(subscriptionId);
            if (oldSitemapPage != null) {
                this.removeCallbackFromListener(oldSitemapPage, callback);
            }
        } else {
            throw new IllegalArgumentException("Subscription " + subscriptionId + " does not exist!");
        }
        this.addCallbackToListener(sitemapName, pageId, callback);
        this.pageOfSubscription.put(subscriptionId, this.getValue(sitemapName, pageId));
        this.logger.debug("Subscription {} changed to page {} of sitemap {} ({} active subscriptions}", new Object[]{subscriptionId, pageId, sitemapName, this.callbacks.size()});
    }

    private void addCallbackToListener(String sitemapName, String pageId, SitemapSubscriptionCallback callback) {
        PageChangeListener listener = this.pageChangeListeners.get(this.getValue(sitemapName, pageId));
        if (listener == null) {
            listener = new PageChangeListener(sitemapName, pageId, this.itemUIRegistry, this.collectWidgets(sitemapName, pageId));
            this.pageChangeListeners.put(this.getValue(sitemapName, pageId), listener);
        }
        if (listener != null) {
            listener.addCallback(callback);
        }
    }

    private EList<Widget> collectWidgets(String sitemapName, String pageId) {
        BasicEList widgets = new BasicEList();
        Sitemap sitemap = this.getSitemap(sitemapName);
        if (sitemap != null) {
            if (pageId.equals(sitemap.getName())) {
                widgets = this.itemUIRegistry.getChildren(sitemap);
            } else {
                Widget pageWidget = this.itemUIRegistry.getWidget(sitemap, pageId);
                if (pageWidget instanceof LinkableWidget) {
                    widgets = this.itemUIRegistry.getChildren((LinkableWidget)pageWidget);
                    widgets.add((Object)pageWidget);
                }
            }
        }
        return widgets;
    }

    private void removeCallbackFromListener(String sitemapPage, SitemapSubscriptionCallback callback) {
        PageChangeListener oldListener = this.pageChangeListeners.get(sitemapPage);
        if (oldListener != null) {
            oldListener.removeCallback(callback);
            if (!this.pageOfSubscription.values().contains(sitemapPage)) {
                oldListener.dispose();
                this.pageChangeListeners.remove(sitemapPage);
            }
        }
    }

    private String getValue(String sitemapName, String pageId) {
        return String.valueOf(sitemapName) + SITEMAP_PAGE_SEPARATOR + pageId;
    }

    private Sitemap getSitemap(String sitemapName) {
        for (SitemapProvider provider : this.sitemapProviders) {
            Sitemap sitemap = provider.getSitemap(sitemapName);
            if (sitemap == null) continue;
            return sitemap;
        }
        return null;
    }

    public void modelChanged(String modelName, EventType type) {
        if (type != EventType.MODIFIED || !modelName.endsWith(SITEMAP_SUFFIX)) {
            return;
        }
        String changedSitemapName = StringUtils.removeEnd((String)modelName, (String)SITEMAP_SUFFIX);
        for (Map.Entry<String, PageChangeListener> listenerEntry : this.pageChangeListeners.entrySet()) {
            String sitemapWithPage = listenerEntry.getKey();
            String sitemapName = this.extractSitemapName(sitemapWithPage);
            String pageId = this.extractPageId(sitemapWithPage);
            if (!sitemapName.equals(changedSitemapName)) continue;
            EList<Widget> widgets = this.collectWidgets(sitemapName, pageId);
            listenerEntry.getValue().sitemapContentChanged(widgets);
        }
    }

    public void checkAliveClients() {
        for (Map.Entry<String, Long> entry : this.creationDates.entrySet()) {
            String subscriptionId = entry.getKey();
            SitemapSubscriptionCallback callback = this.callbacks.get(subscriptionId);
            if (this.getPageId(subscriptionId) != null || callback == null || entry.getValue() + 30000L >= System.currentTimeMillis()) continue;
            this.logger.debug("Release subscription {} as sitemap page is not set", (Object)subscriptionId);
            this.removeSubscription(subscriptionId);
            callback.onRelease(subscriptionId);
        }
        for (Map.Entry<String, Object> entry : this.pageChangeListeners.entrySet()) {
            ((PageChangeListener)entry.getValue()).sendAliveEvent();
        }
    }

    public Set<String> getSubscribedEventTypes() {
        return Collections.singleton(ItemStatePredictedEvent.TYPE);
    }

    public @Nullable EventFilter getEventFilter() {
        return null;
    }

    public void receive(Event event) {
        if (event instanceof ItemStatePredictedEvent) {
            ItemStatePredictedEvent prediction = (ItemStatePredictedEvent)event;
            Item item = (Item)this.itemUIRegistry.get((Object)prediction.getItemName());
            if (item instanceof GroupItem) {
                return;
            }
            for (PageChangeListener pageChangeListener : this.pageChangeListeners.values()) {
                if (prediction.isConfirmation()) {
                    pageChangeListener.keepCurrentState(item);
                    continue;
                }
                pageChangeListener.changeStateTo(item, prediction.getPredictedState());
            }
        }
    }

    public static interface SitemapSubscriptionCallback {
        public void onEvent(SitemapEvent var1);

        public void onRelease(String var1);
    }
}

