/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.sitemap.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.io.rest.core.item.EnrichedItemDTOMapper;
import org.eclipse.smarthome.io.rest.sitemap.SitemapSubscriptionService;
import org.eclipse.smarthome.io.rest.sitemap.internal.ServerAliveEvent;
import org.eclipse.smarthome.io.rest.sitemap.internal.SitemapChangedEvent;
import org.eclipse.smarthome.io.rest.sitemap.internal.SitemapEvent;
import org.eclipse.smarthome.io.rest.sitemap.internal.SitemapWidgetEvent;
import org.eclipse.smarthome.model.sitemap.Chart;
import org.eclipse.smarthome.model.sitemap.Frame;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.VisibilityRule;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;

public class PageChangeListener
implements StateChangeListener {
    private static final int REVERT_INTERVAL = 300;
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"common");
    private final String sitemapName;
    private final String pageId;
    private final ItemUIRegistry itemUIRegistry;
    private EList<Widget> widgets;
    private Set<Item> items;
    private final List<SitemapSubscriptionService.SitemapSubscriptionCallback> callbacks = Collections.synchronizedList(new ArrayList());
    private Set<SitemapSubscriptionService.SitemapSubscriptionCallback> distinctCallbacks = Collections.emptySet();

    public PageChangeListener(String sitemapName, String pageId, ItemUIRegistry itemUIRegistry, EList<Widget> widgets) {
        this.sitemapName = sitemapName;
        this.pageId = pageId;
        this.itemUIRegistry = itemUIRegistry;
        this.updateItemsAndWidgets(widgets);
    }

    private void updateItemsAndWidgets(EList<Widget> widgets) {
        if (this.widgets != null) {
            this.items = this.getAllItems(this.widgets);
            for (Item item : this.items) {
                if (!(item instanceof GenericItem)) continue;
                ((GenericItem)item).removeStateChangeListener((StateChangeListener)this);
            }
        }
        this.widgets = widgets;
        this.items = this.getAllItems(widgets);
        for (Item item : this.items) {
            if (!(item instanceof GenericItem)) continue;
            ((GenericItem)item).addStateChangeListener((StateChangeListener)this);
        }
    }

    public String getSitemapName() {
        return this.sitemapName;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void addCallback(SitemapSubscriptionService.SitemapSubscriptionCallback callback) {
        this.callbacks.add(callback);
        this.distinctCallbacks = new HashSet<SitemapSubscriptionService.SitemapSubscriptionCallback>(this.callbacks);
    }

    public void removeCallback(SitemapSubscriptionService.SitemapSubscriptionCallback callback) {
        this.callbacks.remove(callback);
        this.distinctCallbacks = new HashSet<SitemapSubscriptionService.SitemapSubscriptionCallback>(this.callbacks);
    }

    public void dispose() {
        for (Item item : this.items) {
            if (item instanceof GenericItem) {
                ((GenericItem)item).removeStateChangeListener((StateChangeListener)this);
                continue;
            }
            if (!(item instanceof GroupItem)) continue;
            ((GroupItem)item).removeStateChangeListener((StateChangeListener)this);
        }
    }

    private Set<Item> getAllItems(EList<Widget> widgets) {
        HashSet<Item> items = new HashSet<Item>();
        if (this.itemUIRegistry != null) {
            for (Widget widget : widgets) {
                this.addItemWithName(items, widget.getItem());
                if (widget instanceof Frame) {
                    items.addAll(this.getAllItems((EList<Widget>)((Frame)widget).getChildren()));
                }
                for (VisibilityRule rule : widget.getVisibility()) {
                    this.addItemWithName(items, rule.getItem());
                }
                for (VisibilityRule rule : widget.getLabelColor()) {
                    this.addItemWithName(items, rule.getItem());
                }
                for (VisibilityRule rule : widget.getValueColor()) {
                    this.addItemWithName(items, rule.getItem());
                }
            }
        }
        return items;
    }

    private void addItemWithName(Set<Item> items, String itemName) {
        if (itemName != null) {
            try {
                Item item = this.itemUIRegistry.getItem(itemName);
                items.add(item);
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
    }

    private void constructAndSendEvents(Item item, State newState) {
        Set<SitemapEvent> events = this.constructSitemapEvents(item, newState, (List<Widget>)this.widgets);
        for (SitemapEvent event : events) {
            for (SitemapSubscriptionService.SitemapSubscriptionCallback callback : this.distinctCallbacks) {
                callback.onEvent(event);
            }
        }
    }

    public void stateChanged(Item item, State oldState, State newState) {
        if (item instanceof GroupItem) {
            return;
        }
        this.constructAndSendEvents(item, newState);
    }

    public void stateUpdated(Item item, State state) {
        if (!(item instanceof GroupItem)) {
            return;
        }
        this.constructAndSendEvents(item, state);
    }

    public void keepCurrentState(Item item) {
        this.scheduler.schedule(() -> this.constructAndSendEvents(item, item.getState()), 300L, TimeUnit.MILLISECONDS);
    }

    public void changeStateTo(Item item, State state) {
        this.constructAndSendEvents(item, state);
    }

    private Set<SitemapEvent> constructSitemapEvents(Item item, State state, List<Widget> widgets) {
        HashSet<SitemapEvent> events = new HashSet<SitemapEvent>();
        for (Widget w : widgets) {
            boolean skipWidget;
            if (w instanceof Frame) {
                events.addAll(this.constructSitemapEvents(item, state, (List<Widget>)this.itemUIRegistry.getChildren((LinkableWidget)((Frame)w))));
            }
            boolean bl = skipWidget = w.getItem() == null || !w.getItem().equals(item.getName());
            if (!skipWidget && w instanceof Chart) {
                Chart chartWidget = (Chart)w;
                boolean bl2 = skipWidget = chartWidget.getRefresh() > 0;
            }
            if (skipWidget && !this.definesVisibilityOrColor(w, item.getName())) continue;
            SitemapWidgetEvent event = new SitemapWidgetEvent();
            event.sitemapName = this.sitemapName;
            event.pageId = this.pageId;
            event.label = this.itemUIRegistry.getLabel(w);
            event.labelcolor = this.itemUIRegistry.getLabelColor(w);
            event.valuecolor = this.itemUIRegistry.getValueColor(w);
            event.widgetId = this.itemUIRegistry.getWidgetId(w);
            event.visibility = this.itemUIRegistry.getVisiblity(w);
            String widgetTypeName = w.eClass().getInstanceTypeName().substring(w.eClass().getInstanceTypeName().lastIndexOf(".") + 1);
            boolean drillDown = "mapview".equalsIgnoreCase(widgetTypeName);
            Predicate<Item> itemFilter = i -> i.getType().equals("Location");
            event.item = EnrichedItemDTOMapper.map((Item)item, (boolean)drillDown, itemFilter, null, null);
            event.state = this.itemUIRegistry.convertState(w, item, state).toFullString();
            if (event.state != null && event.state.equals(event.item.state)) {
                event.state = null;
            }
            events.add(event);
        }
        return events;
    }

    private boolean definesVisibilityOrColor(Widget w, String name) {
        for (VisibilityRule rule : w.getVisibility()) {
            if (!name.equals(rule.getItem())) continue;
            return true;
        }
        for (VisibilityRule rule : w.getLabelColor()) {
            if (!name.equals(rule.getItem())) continue;
            return true;
        }
        for (VisibilityRule rule : w.getValueColor()) {
            if (!name.equals(rule.getItem())) continue;
            return true;
        }
        return false;
    }

    public void sitemapContentChanged(EList<Widget> widgets) {
        this.updateItemsAndWidgets(widgets);
        SitemapChangedEvent changeEvent = new SitemapChangedEvent();
        changeEvent.pageId = this.pageId;
        changeEvent.sitemapName = this.sitemapName;
        for (SitemapSubscriptionService.SitemapSubscriptionCallback callback : this.distinctCallbacks) {
            callback.onEvent(changeEvent);
        }
    }

    public void sendAliveEvent() {
        ServerAliveEvent aliveEvent = new ServerAliveEvent();
        aliveEvent.pageId = this.pageId;
        aliveEvent.sitemapName = this.sitemapName;
        for (SitemapSubscriptionService.SitemapSubscriptionCallback callback : this.distinctCallbacks) {
            callback.onEvent(aliveEvent);
        }
    }
}

