/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.sse.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.io.rest.sse.beans.EventBean;
import org.glassfish.jersey.media.sse.OutboundEvent;

public class SseUtil {
    static final String TOPIC_VALIDATE_PATTERN = "(\\w*\\*?\\/?,?\\s*)*";
    public static final boolean SERVLET3_SUPPORT;
    private static ThreadLocal<Boolean> blockingSseEnabled;

    static {
        block5: {
            boolean servlet3 = false;
            try {
                try {
                    servlet3 = ServletRequest.class.getMethod("startAsync", new Class[0]) != null;
                }
                catch (Exception exception) {
                    SERVLET3_SUPPORT = servlet3;
                    break block5;
                }
            }
            catch (Throwable throwable) {
                SERVLET3_SUPPORT = servlet3;
                throw throwable;
            }
            SERVLET3_SUPPORT = servlet3;
        }
        blockingSseEnabled = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
    }

    public static OutboundEvent buildEvent(Event event) {
        EventBean eventBean = new EventBean();
        eventBean.topic = event.getTopic();
        eventBean.type = event.getType();
        eventBean.payload = event.getPayload();
        OutboundEvent.Builder eventBuilder = new OutboundEvent.Builder();
        OutboundEvent outboundEvent = eventBuilder.name("message").mediaType(MediaType.APPLICATION_JSON_TYPE).data((Object)eventBean).build();
        return outboundEvent;
    }

    public static boolean shouldAsyncBlock() {
        return blockingSseEnabled.get();
    }

    public static void enableBlockingSse() {
        blockingSseEnabled.set(true);
    }

    public static boolean isValidTopicFilter(String topicFilter) {
        return StringUtils.isEmpty((String)topicFilter) || topicFilter.matches(TOPIC_VALIDATE_PATTERN);
    }

    public static List<String> convertToRegex(String topicFilter) {
        ArrayList<String> filters = new ArrayList<String>();
        if (StringUtils.isEmpty((String)topicFilter)) {
            filters.add(".*");
        } else {
            StringTokenizer tokenizer = new StringTokenizer(topicFilter, ",");
            while (tokenizer.hasMoreElements()) {
                String regex = String.valueOf(tokenizer.nextToken().trim().replace("*", ".*")) + ".*";
                filters.add(regex);
            }
        }
        return filters;
    }
}

