/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.voice.internal;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.core.voice.VoiceManager;
import org.eclipse.smarthome.core.voice.text.HumanLanguageInterpreter;
import org.eclipse.smarthome.core.voice.text.InterpretationException;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.LocaleService;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.voice.internal.HLIMapper;
import org.eclipse.smarthome.io.rest.voice.internal.HumanLanguageInterpreterDTO;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Path(value="voice")
@RolesAllowed(value={"user", "administrator"})
@Api(value="voice")
@Component
public class VoiceResource
implements RESTResource {
    static final String PATH_SITEMAPS = "voice";
    @Context
    UriInfo uriInfo;
    private VoiceManager voiceManager;
    private LocaleService localeService;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setVoiceManager(VoiceManager voiceManager) {
        this.voiceManager = voiceManager;
    }

    public void unsetVoiceManager(VoiceManager voiceManager) {
        this.voiceManager = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setLocaleService(LocaleService localeService) {
        this.localeService = localeService;
    }

    protected void unsetLocaleService(LocaleService localeService) {
        this.localeService = null;
    }

    @GET
    @Path(value="/interpreters")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the list of all interpreters.", response=HumanLanguageInterpreterDTO.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response getInterpreters(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language) {
        Locale locale = this.localeService.getLocale(language);
        Collection hlis = this.voiceManager.getHLIs();
        ArrayList<HumanLanguageInterpreterDTO> dtos = new ArrayList<HumanLanguageInterpreterDTO>(hlis.size());
        for (HumanLanguageInterpreter hli : hlis) {
            dtos.add(HLIMapper.map(hli, locale));
        }
        return Response.ok(dtos).build();
    }

    @GET
    @Path(value="/interpreters/{id: [a-zA-Z_0-9]*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a single interpreters.", response=HumanLanguageInterpreterDTO.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Interpreter not found")})
    public Response getInterpreter(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="id") @ApiParam(value="interpreter id", required=true) String id) {
        Locale locale = this.localeService.getLocale(language);
        HumanLanguageInterpreter hli = this.voiceManager.getHLI(id);
        if (hli != null) {
            HumanLanguageInterpreterDTO dto = HLIMapper.map(hli, locale);
            return Response.ok((Object)dto).build();
        }
        return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Interpreter not found");
    }

    @POST
    @Path(value="/interpreters/{id: [a-zA-Z_0-9]*}")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Sends a text to a given human language interpreter.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="No human language interpreter was found."), @ApiResponse(code=400, message="interpretation exception occurs")})
    public Response interpret(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @ApiParam(value="text to interpret", required=true) String text, @PathParam(value="id") @ApiParam(value="interpreter id", required=true) String id) {
        Locale locale = this.localeService.getLocale(language);
        HumanLanguageInterpreter hli = this.voiceManager.getHLI(id);
        if (hli != null) {
            try {
                hli.interpret(locale, text);
                return Response.ok(null, (String)"text/plain").build();
            }
            catch (InterpretationException e) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)e.getMessage());
            }
        }
        return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Interpreter not found");
    }

    @POST
    @Path(value="/interpreters")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Sends a text to the default human language interpreter.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="No human language interpreter was found."), @ApiResponse(code=400, message="interpretation exception occurs")})
    public Response interpret(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @ApiParam(value="text to interpret", required=true) String text) {
        Locale locale = this.localeService.getLocale(language);
        HumanLanguageInterpreter hli = this.voiceManager.getHLI();
        if (hli != null) {
            try {
                hli.interpret(locale, text);
                return Response.ok(null, (String)"text/plain").build();
            }
            catch (InterpretationException e) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)e.getMessage());
            }
        }
        return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"No interpreter found");
    }

    public boolean isSatisfied() {
        return this.voiceManager != null && this.localeService != null;
    }
}

