/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mqtt;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.io.transport.mqtt.MqttActionCallback;
import org.eclipse.smarthome.io.transport.mqtt.MqttConnectionObserver;
import org.eclipse.smarthome.io.transport.mqtt.MqttConnectionState;
import org.eclipse.smarthome.io.transport.mqtt.MqttException;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageSubscriber;
import org.eclipse.smarthome.io.transport.mqtt.MqttWillAndTestament;
import org.eclipse.smarthome.io.transport.mqtt.internal.ClientCallback;
import org.eclipse.smarthome.io.transport.mqtt.internal.MqttActionAdapterCallback;
import org.eclipse.smarthome.io.transport.mqtt.internal.TopicSubscribers;
import org.eclipse.smarthome.io.transport.mqtt.reconnect.AbstractReconnectStrategy;
import org.eclipse.smarthome.io.transport.mqtt.reconnect.PeriodicReconnectStrategy;
import org.eclipse.smarthome.io.transport.mqtt.sslcontext.AcceptAllCertificatesSSLContext;
import org.eclipse.smarthome.io.transport.mqtt.sslcontext.SSLContextProvider;
import org.osgi.service.cm.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class MqttBrokerConnection {
    final Logger logger = LoggerFactory.getLogger(MqttBrokerConnection.class);
    public static final int DEFAULT_KEEPALIVE_INTERVAL = 60;
    public static final int DEFAULT_QOS = 0;
    protected final Protocol protocol;
    protected final String host;
    protected final int port;
    protected final boolean secure;
    protected final String clientId;
    private @Nullable String user;
    private @Nullable String password;
    private int qos = 0;
    private boolean retain = false;
    private @Nullable MqttWillAndTestament lastWill;
    private @Nullable Path persistencePath;
    protected @Nullable AbstractReconnectStrategy reconnectStrategy;
    private SSLContextProvider sslContextProvider = new AcceptAllCertificatesSSLContext();
    private int keepAliveInterval = 60;
    protected @Nullable MqttAsyncClient client;
    protected @Nullable MqttClientPersistence dataStore;
    protected boolean isConnecting = false;
    protected final List<MqttConnectionObserver> connectionObservers = new CopyOnWriteArrayList<MqttConnectionObserver>();
    protected final Map<String, TopicSubscribers> subscribers = new HashMap<String, TopicSubscribers>();
    protected final AtomicReference<@Nullable ScheduledFuture<?>> timeoutFuture = new AtomicReference<Object>(null);
    protected @Nullable ScheduledExecutorService timeoutExecutor;
    private int timeout = 1200;
    protected ClientCallback clientCallback = new ClientCallback(this, this.connectionObservers, this.subscribers);
    protected ConnectionCallback connectionCallback;
    protected IMqttActionListener actionCallback = new MqttActionAdapterCallback();

    public MqttBrokerConnection(String host, @Nullable Integer port, boolean secure, @Nullable String clientId) {
        this(Protocol.TCP, host, port, secure, clientId);
    }

    public MqttBrokerConnection(Protocol protocol, String host, @Nullable Integer port, boolean secure, @Nullable String clientId) {
        this.protocol = protocol;
        this.host = host;
        this.secure = secure;
        String newClientID = clientId;
        if (newClientID == null) {
            newClientID = MqttClient.generateClientId();
        } else if (newClientID.length() > 65535) {
            throw new IllegalArgumentException("Client ID cannot be longer than 65535 characters");
        }
        if (port != null && (port <= 0 || port > 65535)) {
            throw new IllegalArgumentException("Port is not within a valid range");
        }
        this.port = port != null ? port : (secure ? 8883 : 1883);
        this.clientId = newClientID;
        this.setReconnectStrategy(new PeriodicReconnectStrategy());
        this.connectionCallback = new ConnectionCallback(this);
    }

    public void setReconnectStrategy(AbstractReconnectStrategy reconnectStrategy) {
        this.reconnectStrategy = reconnectStrategy;
        reconnectStrategy.setBrokerConnection(this);
    }

    public @Nullable AbstractReconnectStrategy getReconnectStrategy() {
        return this.reconnectStrategy;
    }

    public void setTimeoutExecutor(@Nullable ScheduledExecutorService executor, int timeoutInMS) {
        this.timeoutExecutor = executor;
        this.timeout = timeoutInMS;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setCredentials(@Nullable String user, @Nullable String password) {
        this.user = user;
        this.password = password;
    }

    public @Nullable String getPassword() {
        return this.password;
    }

    public @Nullable String getUser() {
        return this.user;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int qos) {
        if (qos < 0 || qos > 2) {
            throw new IllegalArgumentException("The quality of service parameter must be >=0 and <=2.");
        }
        this.qos = qos;
    }

    public boolean isRetain() {
        return this.retain;
    }

    public void setRetain(boolean retain) {
        this.retain = retain;
    }

    public @Nullable MqttWillAndTestament getLastWill() {
        return this.lastWill;
    }

    public void setLastWill(@Nullable MqttWillAndTestament lastWill, boolean applyImmediately) throws ConfigurationException, MqttException {
        this.lastWill = lastWill;
        if (applyImmediately) {
            this.stop();
            this.start();
        }
    }

    public void setLastWill(@Nullable MqttWillAndTestament lastWill) {
        this.lastWill = lastWill;
    }

    public void setPersistencePath(@Nullable Path persistencePath) {
        this.persistencePath = persistencePath;
    }

    public String getClientId() {
        return this.clientId;
    }

    public MqttConnectionState connectionState() {
        if (this.isConnecting) {
            return MqttConnectionState.CONNECTING;
        }
        return this.client != null && this.client.isConnected() ? MqttConnectionState.CONNECTED : MqttConnectionState.DISCONNECTED;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        if (keepAliveInterval <= 0) {
            throw new IllegalArgumentException("Keep alive cannot be <=0");
        }
        this.keepAliveInterval = keepAliveInterval;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public SSLContextProvider getSSLContextProvider() {
        return this.sslContextProvider;
    }

    public void setSSLContextProvider(SSLContextProvider sslContextProvider) {
        this.sslContextProvider = sslContextProvider;
    }

    public boolean hasSubscribers() {
        return !this.subscribers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Boolean> subscribe(String topic, MqttMessageSubscriber subscriber) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Map<String, TopicSubscribers> map = this.subscribers;
        synchronized (map) {
            TopicSubscribers subscriberList = this.subscribers.getOrDefault(topic, new TopicSubscribers(topic));
            this.subscribers.put(topic, subscriberList);
            subscriberList.add(subscriber);
        }
        MqttAsyncClient client = this.client;
        if (client == null) {
            future.completeExceptionally(new Exception("No MQTT client"));
            return future;
        }
        if (client.isConnected()) {
            try {
                client.subscribe(topic, this.qos, future, this.actionCallback);
            }
            catch (org.eclipse.paho.client.mqttv3.MqttException e) {
                future.completeExceptionally(e);
            }
        } else {
            future.complete(false);
        }
        return future;
    }

    protected CompletableFuture<Boolean> subscribeRaw(String topic) {
        this.logger.trace("subscribeRaw message consumer for topic '{}' from broker '{}'", (Object)topic, (Object)this.host);
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        try {
            MqttAsyncClient client = this.client;
            if (client != null && client.isConnected()) {
                client.subscribe(topic, this.qos, future, this.actionCallback);
            } else {
                future.complete(false);
            }
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            this.logger.info("Error subscribing to topic {}", (Object)topic, (Object)e);
            future.completeExceptionally(e);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Boolean> unsubscribe(String topic, MqttMessageSubscriber subscriber) {
        Map<String, TopicSubscribers> map = this.subscribers;
        synchronized (map) {
            @Nullable List list = this.subscribers.get(topic);
            if (list == null) {
                return CompletableFuture.completedFuture(true);
            }
            list.remove(subscriber);
            if (!list.isEmpty()) {
                return CompletableFuture.completedFuture(true);
            }
            this.subscribers.remove(topic);
            MqttAsyncClient client = this.client;
            if (client != null) {
                return this.unsubscribeRaw(client, topic);
            }
            return CompletableFuture.completedFuture(false);
        }
    }

    protected CompletableFuture<Boolean> unsubscribeRaw(MqttAsyncClient client, String topic) {
        this.logger.trace("Unsubscribing message consumer for topic '{}' from broker '{}'", (Object)topic, (Object)this.host);
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        try {
            if (client.isConnected()) {
                client.unsubscribe(topic, future, this.actionCallback);
            } else {
                future.complete(false);
            }
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            this.logger.info("Error unsubscribing topic from broker", (Throwable)e);
            future.completeExceptionally(e);
        }
        return future;
    }

    public synchronized void addConnectionObserver(MqttConnectionObserver connectionObserver) {
        this.connectionObservers.add(connectionObserver);
    }

    public synchronized void removeConnectionObserver(MqttConnectionObserver connectionObserver) {
        this.connectionObservers.remove(connectionObserver);
    }

    public boolean hasConnectionObservers() {
        return !this.connectionObservers.isEmpty();
    }

    MqttConnectOptions createMqttOptions() throws ConfigurationException {
        MqttConnectOptions options = new MqttConnectOptions();
        if (!StringUtils.isBlank((String)this.user)) {
            options.setUserName(this.user);
        }
        if (!StringUtils.isBlank((String)this.password) && this.password != null) {
            options.setPassword(this.password.toCharArray());
        }
        if (this.secure) {
            options.setSocketFactory((SocketFactory)this.sslContextProvider.getContext().getSocketFactory());
        }
        if (this.lastWill != null) {
            MqttWillAndTestament lastWill = this.lastWill;
            options.setWill(lastWill.getTopic(), lastWill.getPayload(), lastWill.getQos(), lastWill.isRetain());
        }
        options.setKeepAliveInterval(this.keepAliveInterval);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Boolean> start() {
        ScheduledFuture<?> timeoutFuture;
        MqttAsyncClient _client;
        MqttBrokerConnection mqttBrokerConnection = this;
        synchronized (mqttBrokerConnection) {
            if (this.connectionState() != MqttConnectionState.DISCONNECTED) {
                return CompletableFuture.completedFuture(true);
            }
            this.isConnecting = true;
            this.connectionObservers.forEach(o -> o.connectionStateChanged(MqttConnectionState.CONNECTING, null));
        }
        if (this.reconnectStrategy != null) {
            this.reconnectStrategy.start();
        }
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (org.eclipse.paho.client.mqttv3.MqttException mqttException) {}
            this.client = null;
        }
        CompletableFuture<Boolean> future = this.connectionCallback.createFuture();
        StringBuilder serverURI = new StringBuilder();
        switch (this.protocol) {
            case TCP: {
                serverURI.append(this.secure ? "ssl://" : "tcp://");
                break;
            }
            case WEBSOCKETS: {
                serverURI.append(this.secure ? "wss://" : "ws://");
                break;
            }
            default: {
                future.completeExceptionally(new ConfigurationException("protocol", "Protocol unknown"));
                return future;
            }
        }
        serverURI.append(this.host);
        serverURI.append(":");
        serverURI.append(this.port);
        Path persistencePath = this.persistencePath;
        if (persistencePath == null) {
            persistencePath = Paths.get(ConfigConstants.getUserDataFolder(), new String[0]).resolve("mqtt").resolve(this.host);
        }
        try {
            persistencePath = Files.createDirectories(persistencePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            future.completeExceptionally(new MqttException(e));
            return future;
        }
        MqttDefaultFilePersistence _dataStore = new MqttDefaultFilePersistence(persistencePath.toString());
        try {
            _client = this.createClient(serverURI.toString(), this.clientId, (MqttClientPersistence)_dataStore);
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            future.completeExceptionally(new MqttException(e));
            return future;
        }
        this.client = _client;
        this.dataStore = _dataStore;
        _client.setCallback((MqttCallback)this.clientCallback);
        try {
            _client.connect(this.createMqttOptions(), null, (IMqttActionListener)this.connectionCallback);
            this.logger.info("Starting MQTT broker connection to '{}' with clientid {} and file store '{}'", new Object[]{this.host, this.getClientId(), persistencePath});
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException | ConfigurationException e) {
            future.completeExceptionally(new MqttException(e));
            return future;
        }
        ScheduledExecutorService executor = this.timeoutExecutor;
        if (executor != null && (timeoutFuture = this.timeoutFuture.getAndSet(executor.schedule(() -> this.connectionCallback.onFailure(null, new TimeoutException()), (long)this.timeout, TimeUnit.MILLISECONDS))) != null) {
            timeoutFuture.cancel(false);
        }
        return future;
    }

    protected MqttAsyncClient createClient(String serverURI, String clientId, MqttClientPersistence dataStore) throws org.eclipse.paho.client.mqttv3.MqttException {
        return new MqttAsyncClient(serverURI, clientId, dataStore);
    }

    protected boolean finalizeStopAfterDisconnect(boolean v) {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception exception) {}
        }
        this.client = null;
        if (this.dataStore != null) {
            try {
                this.dataStore.close();
            }
            catch (Exception exception) {}
            this.dataStore = null;
        }
        this.connectionObservers.forEach(o -> o.connectionStateChanged(MqttConnectionState.DISCONNECTED, null));
        return v;
    }

    public CompletableFuture<Void> unsubscribeAll() {
        MqttAsyncClient client = this.client;
        ArrayList futures = new ArrayList();
        if (client != null) {
            this.subscribers.forEach((topic, subList) -> futures.add(this.unsubscribeRaw(client, (String)topic)));
            this.subscribers.clear();
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
    }

    public CompletableFuture<Boolean> stop() {
        MqttAsyncClient client = this.client;
        if (client == null) {
            return CompletableFuture.completedFuture(true);
        }
        this.logger.trace("Closing the MQTT broker connection '{}'", (Object)this.host);
        this.isConnecting = false;
        this.cancelTimeoutFuture();
        if (this.reconnectStrategy != null) {
            this.reconnectStrategy.stop();
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        if (client.isConnected()) {
            this.unsubscribeAll().thenRunAsync(() -> {
                try {
                    client.disconnect(100L).waitForCompletion(100L);
                    if (client.isConnected()) {
                        client.disconnectForcibly();
                    }
                    future.complete(true);
                }
                catch (org.eclipse.paho.client.mqttv3.MqttException e) {
                    this.logger.debug("Error while closing connection to broker", (Throwable)e);
                    future.complete(false);
                }
            });
        } else {
            future.complete(true);
        }
        return future.thenApply(this::finalizeStopAfterDisconnect);
    }

    public void publish(String topic, byte[] payload, int qos, boolean retain, MqttActionCallback listener) {
        MqttAsyncClient client_ = this.client;
        if (client_ == null) {
            listener.onFailure(topic, new MqttException(0));
            return;
        }
        try {
            IMqttDeliveryToken deliveryToken = client_.publish(topic, payload, qos, retain, (Object)listener, this.actionCallback);
            this.logger.debug("Publishing message {} to topic '{}'", (Object)deliveryToken.getMessageId(), (Object)topic);
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            listener.onFailure(topic, new MqttException(e));
        }
    }

    public void publish(String topic, byte[] payload, MqttActionCallback listener) {
        this.publish(topic, payload, this.qos, this.retain, listener);
    }

    public CompletableFuture<Boolean> publish(String topic, byte[] payload) {
        return this.publish(topic, payload, this.qos, this.retain);
    }

    public CompletableFuture<Boolean> publish(String topic, byte[] payload, int qos, boolean retain) {
        MqttAsyncClient client = this.client;
        if (client == null) {
            return CompletableFuture.completedFuture(false);
        }
        CompletableFuture<Boolean> f = new CompletableFuture<Boolean>();
        try {
            client.publish(topic, payload, qos, retain, f, this.actionCallback);
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            f.completeExceptionally(new MqttException(e));
        }
        return f;
    }

    protected void cancelTimeoutFuture() {
        ScheduledFuture timeoutFuture = this.timeoutFuture.getAndSet(null);
        if (timeoutFuture != null) {
            timeoutFuture.cancel(false);
        }
    }

    @NonNullByDefault(value={})
    public class ConnectionCallback
    implements IMqttActionListener {
        private final MqttBrokerConnection connection;
        private final Runnable cancelTimeoutFuture;
        private CompletableFuture<Boolean> future = new CompletableFuture();

        public ConnectionCallback(MqttBrokerConnection mqttBrokerConnectionImpl) {
            this.connection = mqttBrokerConnectionImpl;
            this.cancelTimeoutFuture = mqttBrokerConnectionImpl::cancelTimeoutFuture;
        }

        public void onSuccess(IMqttToken asyncActionToken) {
            this.cancelTimeoutFuture.run();
            this.connection.isConnecting = false;
            if (this.connection.reconnectStrategy != null) {
                this.connection.reconnectStrategy.connectionEstablished();
            }
            ArrayList futures = new ArrayList();
            this.connection.subscribers.forEach((topic, subscriberList) -> futures.add(this.connection.subscribeRaw((String)topic)));
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenRun(() -> {
                this.future.complete(true);
                this.connection.connectionObservers.forEach(o -> o.connectionStateChanged(this.connection.connectionState(), null));
            });
        }

        public void onFailure(@Nullable IMqttToken token, @Nullable Throwable error) {
            this.cancelTimeoutFuture.run();
            Throwable throwable = token != null && token.getException() != null ? token.getException() : error;
            MqttConnectionState connectionState = this.connection.connectionState();
            this.future.complete(false);
            this.connection.connectionObservers.forEach(o -> o.connectionStateChanged(connectionState, throwable));
            if (this.connection.isConnecting) {
                this.connection.isConnecting = false;
                if (this.connection.reconnectStrategy != null) {
                    this.connection.reconnectStrategy.lostConnection();
                }
            }
        }

        public CompletableFuture<Boolean> createFuture() {
            this.future = new CompletableFuture();
            return this.future;
        }
    }

    public static enum Protocol {
        TCP,
        WEBSOCKETS;

    }
}

