/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mqtt.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnectionConfig;
import org.eclipse.smarthome.io.transport.mqtt.MqttException;
import org.eclipse.smarthome.io.transport.mqtt.MqttService;
import org.eclipse.smarthome.io.transport.mqtt.MqttServiceObserver;
import org.eclipse.smarthome.io.transport.mqtt.MqttWillAndTestament;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={MqttService.class}, configurationPid="org.eclipse.smarthome.mqtt", property={"service.pid=org.eclipse.smarthome.mqtt"})
@NonNullByDefault
public class MqttServiceImpl
implements MqttService {
    private final Logger logger = LoggerFactory.getLogger(MqttServiceImpl.class);
    private final Map<String, MqttBrokerConnection> brokerConnections = new ConcurrentHashMap<String, MqttBrokerConnection>();
    private final List<MqttServiceObserver> brokersObservers = new CopyOnWriteArrayList<MqttServiceObserver>();

    @Override
    public void addBrokersListener(MqttServiceObserver observer) {
        this.brokersObservers.add(observer);
    }

    @Override
    public void removeBrokersListener(MqttServiceObserver observer) {
        this.brokersObservers.remove(observer);
    }

    @Override
    public boolean hasBrokerObservers() {
        return !this.brokersObservers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable MqttBrokerConnection getBrokerConnection(String brokerName) {
        Map<String, MqttBrokerConnection> map = this.brokerConnections;
        synchronized (map) {
            return this.brokerConnections.get(brokerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBrokerConnection(String brokerID, MqttBrokerConnection connection) {
        Map<String, MqttBrokerConnection> map = this.brokerConnections;
        synchronized (map) {
            block4: {
                if (!this.brokerConnections.containsKey(brokerID)) break block4;
                return false;
            }
            this.brokerConnections.put(brokerID, connection);
        }
        this.brokersObservers.forEach(o -> o.brokerAdded(brokerID, connection));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable MqttBrokerConnection addBrokerConnection(String brokerID, MqttBrokerConnectionConfig config) throws ConfigurationException, MqttException {
        MqttBrokerConnection connection;
        Map<String, MqttBrokerConnection> map = this.brokerConnections;
        synchronized (map) {
            block7: {
                if (!this.brokerConnections.containsKey(brokerID)) break block7;
                return null;
            }
            String host = config.host;
            if (!StringUtils.isNotBlank((String)host) || host == null) {
                throw new ConfigurationException("host", "You need to provide a hostname/IP!");
            }
            connection = new MqttBrokerConnection(host, config.port, config.secure, config.clientID);
            this.brokerConnections.put(brokerID, connection);
        }
        connection.setCredentials(config.username, config.password);
        if (config.keepAlive != null) {
            connection.setKeepAliveInterval(config.keepAlive);
        }
        connection.setQos(config.qos);
        connection.setRetain(config.retainMessages);
        if (config.lwtTopic != null) {
            String topic = config.lwtTopic;
            MqttWillAndTestament will = new MqttWillAndTestament(topic, config.lwtMessage != null ? config.lwtMessage.getBytes() : null, config.lwtQos, config.lwtRetain);
            this.logger.debug("Setting last will: {}", (Object)will);
            connection.setLastWill(will);
        }
        this.brokersObservers.forEach(o -> o.brokerAdded(brokerID, connection));
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable MqttBrokerConnection removeBrokerConnection(String brokerID) {
        Map<String, MqttBrokerConnection> map = this.brokerConnections;
        synchronized (map) {
            @Nullable MqttBrokerConnection connection = this.brokerConnections.remove(brokerID);
            if (connection != null) {
                this.brokersObservers.forEach(o -> o.brokerRemoved(brokerID, connection));
            }
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, MqttBrokerConnection> getAllBrokerConnections() {
        Map<String, MqttBrokerConnection> map = this.brokerConnections;
        synchronized (map) {
            return Collections.unmodifiableMap(this.brokerConnections);
        }
    }
}

