/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.serial.rxtx;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.io.transport.serial.SerialPort;
import org.eclipse.smarthome.io.transport.serial.SerialPortEvent;
import org.eclipse.smarthome.io.transport.serial.SerialPortEventListener;
import org.eclipse.smarthome.io.transport.serial.UnsupportedCommOperationException;
import org.eclipse.smarthome.io.transport.serial.internal.SerialPortEventImpl;

@NonNullByDefault
public class RxTxSerialPort
implements SerialPort {
    private final gnu.io.SerialPort sp;

    public RxTxSerialPort(gnu.io.SerialPort sp) {
        this.sp = sp;
    }

    public void close() {
        this.sp.close();
    }

    public void setSerialPortParams(int baudrate, int dataBits, int stopBits, int parity) throws UnsupportedCommOperationException {
        try {
            this.sp.setSerialPortParams(baudrate, dataBits, stopBits, parity);
        }
        catch (gnu.io.UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new UnsupportedCommOperationException();
        }
    }

    public @Nullable InputStream getInputStream() throws IOException {
        return this.sp.getInputStream();
    }

    public @Nullable OutputStream getOutputStream() throws IOException {
        return this.sp.getOutputStream();
    }

    public void addEventListener(final SerialPortEventListener listener) throws TooManyListenersException {
        this.sp.addEventListener(new gnu.io.SerialPortEventListener(){

            public void serialEvent(@Nullable gnu.io.SerialPortEvent event) {
                if (event == null) {
                    return;
                }
                listener.serialEvent((SerialPortEvent)new SerialPortEventImpl(event));
            }
        });
    }

    public void removeEventListener() {
        this.sp.removeEventListener();
    }

    public void notifyOnDataAvailable(boolean enable) {
        this.sp.notifyOnDataAvailable(enable);
    }

    public void notifyOnBreakInterrupt(boolean enable) {
        this.sp.notifyOnBreakInterrupt(enable);
    }

    public void notifyOnFramingError(boolean enable) {
        this.sp.notifyOnFramingError(enable);
    }

    public void notifyOnOverrunError(boolean enable) {
        this.sp.notifyOnOverrunError(enable);
    }

    public void notifyOnParityError(boolean enable) {
        this.sp.notifyOnParityError(enable);
    }

    public void setRTS(boolean enable) {
        this.sp.setRTS(enable);
    }

    public void enableReceiveTimeout(int timeout) throws UnsupportedCommOperationException {
        if (timeout < 0) {
            throw new IllegalArgumentException(String.format("timeout must be non negative (is: %d)", timeout));
        }
        try {
            this.sp.enableReceiveTimeout(timeout);
        }
        catch (gnu.io.UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new UnsupportedCommOperationException();
        }
    }

    public void disableReceiveTimeout() {
        this.sp.disableReceiveTimeout();
    }

    public String getName() {
        return this.sp.getName();
    }

    public void setFlowControlMode(int flowcontrolRtsctsOut) throws UnsupportedCommOperationException {
        try {
            this.sp.setFlowControlMode(flowcontrolRtsctsOut);
        }
        catch (gnu.io.UnsupportedCommOperationException e) {
            throw new UnsupportedCommOperationException((Throwable)e);
        }
    }

    public void enableReceiveThreshold(int i) throws UnsupportedCommOperationException {
        try {
            this.sp.enableReceiveThreshold(i);
        }
        catch (gnu.io.UnsupportedCommOperationException e) {
            throw new UnsupportedCommOperationException((Throwable)e);
        }
    }
}

