/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.serial.internal;

import java.net.URI;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.io.transport.serial.SerialPortIdentifier;
import org.eclipse.smarthome.io.transport.serial.SerialPortManager;
import org.eclipse.smarthome.io.transport.serial.SerialPortProvider;
import org.eclipse.smarthome.io.transport.serial.internal.SerialPortRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component
public class SerialPortManagerImpl
implements SerialPortManager {
    private final Logger logger = LoggerFactory.getLogger(SerialPortManagerImpl.class);
    @NonNullByDefault(value={})
    private SerialPortRegistry registry;

    @Reference
    protected void setSerialportRegistry(SerialPortRegistry registry) {
        this.registry = registry;
    }

    protected void unsetSerialportRegistry(SerialPortRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Stream<SerialPortIdentifier> getIdentifiers() {
        if (this.registry == null) {
            this.logger.warn("SerialPortRegistry is not set; no SerialPortIdentifier found");
            return Stream.empty();
        }
        return this.registry.getPortCreators().stream().flatMap(provider -> {
            try {
                return provider.getSerialPortIdentifiers();
            }
            catch (UnsatisfiedLinkError error) {
                this.logger.warn("The provider \"{}\" miss some native code support.", (Object)provider.getClass().getSimpleName(), (Object)error);
                return Stream.empty();
            }
            catch (RuntimeException ex) {
                this.logger.warn("The provider \"{}\" cannot provide its serial port identifiers.", (Object)provider.getClass().getSimpleName(), (Object)ex);
                return Stream.empty();
            }
        });
    }

    @Override
    public @Nullable SerialPortIdentifier getIdentifier(String name) {
        if (this.registry == null) {
            this.logger.warn("SerialPortRegistry is not set; no SerialPortProvider found for: {}", (Object)name);
            return null;
        }
        URI portUri = URI.create(name);
        for (SerialPortProvider provider : this.registry.getPortProvidersForPortName(portUri)) {
            try {
                return provider.getPortIdentifier(portUri);
            }
            catch (UnsatisfiedLinkError error) {
                this.logger.warn("The provider \"{}\" miss some native code support.", (Object)provider.getClass().getSimpleName(), (Object)error);
            }
            catch (RuntimeException ex) {
                this.logger.warn("The provider \"{}\" cannot provide a serial port itendifier for \"{}\".", new Object[]{provider.getClass().getSimpleName(), name, ex});
            }
        }
        this.logger.warn("No SerialPortProvider found for: {}", (Object)name);
        return null;
    }
}

