/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.serial.internal;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.io.transport.serial.ProtocolType;
import org.eclipse.smarthome.io.transport.serial.SerialPortProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={SerialPortRegistry.class})
@NonNullByDefault
public class SerialPortRegistry {
    @NonNullByDefault(value={})
    private final Collection<SerialPortProvider> portCreators = new HashSet<SerialPortProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void registerSerialPortCreator(SerialPortProvider creator) {
        Collection<SerialPortProvider> collection = this.portCreators;
        synchronized (collection) {
            this.portCreators.add(creator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterSerialPortCreator(SerialPortProvider creator) {
        Collection<SerialPortProvider> collection = this.portCreators;
        synchronized (collection) {
            this.portCreators.remove(creator);
        }
    }

    public Collection<SerialPortProvider> getPortProvidersForPortName(URI portName) {
        String scheme = portName.getScheme();
        ProtocolType.PathType pathType = ProtocolType.PathType.fromURI(portName);
        Predicate<SerialPortProvider> filter = scheme != null ? provider -> provider.getAcceptedProtocols().filter(prot -> prot.getScheme().equals(scheme)).count() > 0L : provider -> provider.getAcceptedProtocols().filter(prot -> prot.getPathType().equals((Object)pathType)).count() > 0L;
        return this.portCreators.stream().filter(filter).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SerialPortProvider> getPortCreators() {
        Collection<SerialPortProvider> collection = this.portCreators;
        synchronized (collection) {
            return Collections.unmodifiableCollection(new HashSet<SerialPortProvider>(this.portCreators));
        }
    }
}

