/**
 * Copyright (c) 2014,2019 Contributors to the Eclipse Foundation
 * 
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.model.formatting;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.smarthome.model.services.ItemsGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter;
import org.eclipse.xtext.formatting.impl.FormattingConfig;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.Extension;

/**
 * This class contains custom formatting description.
 */
@SuppressWarnings("all")
public class ItemsFormatter extends AbstractDeclarativeFormatter {
  @Inject
  @Extension
  private ItemsGrammarAccess _itemsGrammarAccess;
  
  @Override
  protected void configureFormatting(final FormattingConfig c) {
    c.setLinewrap(1, 1, 2).before(this._itemsGrammarAccess.getModelGroupItemRule());
    c.setLinewrap(1, 1, 2).before(this._itemsGrammarAccess.getModelItemTypeRule());
    this.withinKeywordPairs(c.setNoSpace(), "<", ">");
    this.withinKeywordPairs(c.setNoSpace(), "(", ")");
    c.setIndentationIncrement().after(this._itemsGrammarAccess.getModelItemTypeRule());
    c.setIndentationDecrement().before(this._itemsGrammarAccess.getModelItemTypeRule());
    c.setIndentationIncrement().after(this._itemsGrammarAccess.getModelGroupItemRule());
    c.setIndentationDecrement().before(this._itemsGrammarAccess.getModelGroupItemRule());
    c.setAutoLinewrap(160);
    c.setLinewrap(0, 1, 2).before(this._itemsGrammarAccess.getSL_COMMENTRule());
    c.setLinewrap(0, 1, 2).before(this._itemsGrammarAccess.getML_COMMENTRule());
    c.setLinewrap(0, 1, 1).after(this._itemsGrammarAccess.getML_COMMENTRule());
  }
  
  public void withinKeywordPairs(final FormattingConfig.NoSpaceLocator locator, final String leftKW, final String rightKW) {
    List<Pair<Keyword, Keyword>> _findKeywordPairs = this._itemsGrammarAccess.findKeywordPairs(leftKW, rightKW);
    for (final Pair<Keyword, Keyword> pair : _findKeywordPairs) {
      {
        locator.after(pair.getFirst());
        locator.before(pair.getSecond());
      }
    }
  }
}
