/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.item.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.AbstractProvider;
import org.eclipse.smarthome.core.items.ActiveItem;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupFunction;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ItemProvider;
import org.eclipse.smarthome.core.items.dto.GroupFunctionDTO;
import org.eclipse.smarthome.core.items.dto.ItemDTOMapper;
import org.eclipse.smarthome.core.types.StateDescriptionFragment;
import org.eclipse.smarthome.core.types.StateDescriptionFragmentBuilder;
import org.eclipse.smarthome.core.types.StateDescriptionFragmentProvider;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.smarthome.model.item.BindingConfigParseException;
import org.eclipse.smarthome.model.item.BindingConfigReader;
import org.eclipse.smarthome.model.item.internal.GenericMetadataProvider;
import org.eclipse.smarthome.model.items.ItemModel;
import org.eclipse.smarthome.model.items.ModelBinding;
import org.eclipse.smarthome.model.items.ModelGroupFunction;
import org.eclipse.smarthome.model.items.ModelGroupItem;
import org.eclipse.smarthome.model.items.ModelItem;
import org.eclipse.smarthome.model.items.ModelNormalItem;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ItemProvider.class, StateDescriptionFragmentProvider.class}, immediate=true)
public class GenericItemProvider
extends AbstractProvider<Item>
implements ModelRepositoryChangeListener,
ItemProvider,
StateDescriptionFragmentProvider {
    private final Logger logger = LoggerFactory.getLogger(GenericItemProvider.class);
    private final Map<String, BindingConfigReader> bindingConfigReaders = new HashMap<String, BindingConfigReader>();
    private ModelRepository modelRepository = null;
    private GenericMetadataProvider genericMetaDataProvider = null;
    private final Map<String, Collection<Item>> itemsMap = new ConcurrentHashMap<String, Collection<Item>>();
    private final Collection<ItemFactory> itemFactorys = new ArrayList<ItemFactory>();
    private final Map<String, StateDescriptionFragment> stateDescriptionFragments = new ConcurrentHashMap<String, StateDescriptionFragment>();
    private Integer rank;
    private boolean active = false;

    protected void activate(Map<String, Object> properties) {
        Object serviceRanking = properties.get("service.ranking");
        this.rank = serviceRanking instanceof Integer ? (Integer)serviceRanking : Integer.valueOf(0);
        this.itemFactorys.forEach(itemFactory -> this.dispatchBindingsPerItemType(null, itemFactory.getSupportedItemTypes()));
        for (String modelName : this.modelRepository.getAllModelNamesOfType("items")) {
            this.modelChanged(modelName, EventType.ADDED);
        }
        this.modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.active = true;
    }

    protected void deactivate() {
        this.active = false;
        this.modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
    }

    public Integer getRank() {
        return this.rank;
    }

    @Reference
    public void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    public void unsetModelRepository(ModelRepository modelRepository) {
        this.modelRepository = null;
    }

    @Reference
    protected void setGenericMetadataProvider(GenericMetadataProvider genericMetadataProvider) {
        this.genericMetaDataProvider = genericMetadataProvider;
    }

    protected void unsetGenericMetadataProvider(GenericMetadataProvider genericMetadataProvider) {
        this.genericMetaDataProvider = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addItemFactory(ItemFactory factory) {
        this.itemFactorys.add(factory);
        if (this.active) {
            this.dispatchBindingsPerItemType(null, factory.getSupportedItemTypes());
        }
    }

    public void removeItemFactory(ItemFactory factory) {
        this.itemFactorys.remove(factory);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addBindingConfigReader(BindingConfigReader reader) {
        if (!this.bindingConfigReaders.containsKey(reader.getBindingType())) {
            this.bindingConfigReaders.put(reader.getBindingType(), reader);
            this.dispatchBindingsPerType(reader, new String[]{reader.getBindingType()});
        } else {
            this.logger.warn("Attempted to register a second BindingConfigReader of type '{}'. The primaraly reader will remain active!", (Object)reader.getBindingType());
        }
    }

    public void removeBindingConfigReader(BindingConfigReader reader) {
        if (this.bindingConfigReaders.get(reader.getBindingType()).equals(reader)) {
            this.bindingConfigReaders.remove(reader.getBindingType());
        }
    }

    public Collection<Item> getAll() {
        ArrayList<Item> items = new ArrayList<Item>();
        this.stateDescriptionFragments.clear();
        for (String name : this.modelRepository.getAllModelNamesOfType("items")) {
            items.addAll(this.getItemsFromModel(name));
        }
        return items;
    }

    private Collection<Item> getItemsFromModel(String modelName) {
        ItemModel model;
        this.logger.debug("Read items from model '{}'", (Object)modelName);
        ArrayList<Item> items = new ArrayList<Item>();
        if (this.modelRepository != null && (model = (ItemModel)this.modelRepository.getModel(modelName)) != null) {
            for (ModelItem modelItem : model.getItems()) {
                Item item = this.createItemFromModelItem(modelItem);
                if (item == null) continue;
                for (String groupName : modelItem.getGroups()) {
                    ((GenericItem)item).addGroupName(groupName);
                }
                items.add(item);
            }
        }
        return items;
    }

    private void processBindingConfigsFromModel(String modelName, EventType type) {
        this.logger.debug("Processing binding configs for items from model '{}'", (Object)modelName);
        if (this.modelRepository != null) {
            ItemModel model = (ItemModel)this.modelRepository.getModel(modelName);
            if (model == null) {
                return;
            }
            for (BindingConfigReader reader : this.bindingConfigReaders.values()) {
                reader.startConfigurationUpdate(modelName);
            }
            if (!EventType.REMOVED.equals((Object)type)) {
                for (ModelItem modelItem : model.getItems()) {
                    this.genericMetaDataProvider.removeMetadata(modelItem.getName());
                    Item item = this.createItemFromModelItem(modelItem);
                    if (item == null) continue;
                    this.internalDispatchBindings(modelName, item, modelItem.getBindings());
                }
            }
            for (BindingConfigReader reader : this.bindingConfigReaders.values()) {
                reader.stopConfigurationUpdate(modelName);
            }
        }
    }

    private Item createItemFromModelItem(ModelItem modelItem) {
        Item item = null;
        if (modelItem instanceof ModelGroupItem) {
            Item baseItem;
            ModelGroupItem modelGroupItem = (ModelGroupItem)modelItem;
            try {
                baseItem = this.createItemOfType(modelGroupItem.getType(), modelGroupItem.getName());
            }
            catch (IllegalArgumentException e) {
                this.logger.debug("Error creating base item for group item '{}', item will be ignored: {}", (Object)modelGroupItem.getName(), (Object)e.getMessage());
                return null;
            }
            if (baseItem != null) {
                ModelGroupFunction function = modelGroupItem.getFunction();
                item = this.applyGroupFunction(baseItem, modelGroupItem, function);
            } else {
                item = new GroupItem(modelGroupItem.getName());
            }
        } else {
            ModelNormalItem normalItem = (ModelNormalItem)modelItem;
            try {
                item = this.createItemOfType(normalItem.getType(), normalItem.getName());
            }
            catch (IllegalArgumentException e) {
                this.logger.debug("Error creating item '{}', item will be ignored: {}", (Object)normalItem.getName(), (Object)e.getMessage());
                return null;
            }
        }
        if (item != null && item instanceof ActiveItem) {
            String label = modelItem.getLabel();
            String format = this.extractFormat(label);
            if (format != null) {
                label = label.substring(0, label.indexOf("[")).trim();
                this.stateDescriptionFragments.put(modelItem.getName(), StateDescriptionFragmentBuilder.create().withPattern(format).build());
            }
            ((ActiveItem)item).setLabel(label);
            ((ActiveItem)item).setCategory(modelItem.getIcon());
            this.assignTags(modelItem, (ActiveItem)item);
            return item;
        }
        return null;
    }

    private String extractFormat(String label) {
        if (label == null) {
            return null;
        }
        String format = null;
        if (label.contains("[") && label.contains("]")) {
            format = label.substring(label.indexOf("[") + 1, label.lastIndexOf("]"));
        }
        return format;
    }

    private void assignTags(ModelItem modelItem, ActiveItem item) {
        EList<String> tags = modelItem.getTags();
        for (String tag : tags) {
            item.addTag(tag);
        }
    }

    private GroupItem applyGroupFunction(Item baseItem, ModelGroupItem modelGroupItem, ModelGroupFunction function) {
        GroupFunctionDTO dto = new GroupFunctionDTO();
        dto.name = function.getName();
        dto.params = (String[])modelGroupItem.getArgs().toArray((Object[])new String[modelGroupItem.getArgs().size()]);
        GroupFunction groupFunction = ItemDTOMapper.mapFunction((Item)baseItem, (GroupFunctionDTO)dto);
        return new GroupItem(modelGroupItem.getName(), baseItem, groupFunction);
    }

    private void dispatchBindingsPerItemType(BindingConfigReader reader, String[] itemTypes) {
        if (this.modelRepository != null) {
            for (String modelName : this.modelRepository.getAllModelNamesOfType("items")) {
                ItemModel model = (ItemModel)this.modelRepository.getModel(modelName);
                if (model != null) {
                    for (ModelItem modelItem : model.getItems()) {
                        String[] stringArray = itemTypes;
                        int n = itemTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Item item;
                            String itemType = stringArray[n2];
                            if (itemType.equals(modelItem.getType()) && (item = this.createItemFromModelItem(modelItem)) != null) {
                                this.internalDispatchBindings(reader, modelName, item, modelItem.getBindings());
                            }
                            ++n2;
                        }
                    }
                    continue;
                }
                this.logger.debug("Model repository returned NULL for model named '{}'", (Object)modelName);
            }
        } else {
            this.logger.warn("ModelRepository is NULL > dispatch bindings aborted!");
        }
    }

    private void dispatchBindingsPerType(BindingConfigReader reader, String[] bindingTypes) {
        if (this.modelRepository != null) {
            for (String modelName : this.modelRepository.getAllModelNamesOfType("items")) {
                ItemModel model = (ItemModel)this.modelRepository.getModel(modelName);
                if (model != null) {
                    for (ModelItem modelItem : model.getItems()) {
                        for (ModelBinding modelBinding : modelItem.getBindings()) {
                            String[] stringArray = bindingTypes;
                            int n = bindingTypes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Item item;
                                String bindingType = stringArray[n2];
                                if (bindingType.equals(modelBinding.getType()) && (item = this.createItemFromModelItem(modelItem)) != null) {
                                    this.internalDispatchBindings(reader, modelName, item, modelItem.getBindings());
                                }
                                ++n2;
                            }
                        }
                    }
                    continue;
                }
                this.logger.debug("Model repository returned NULL for model named '{}'", (Object)modelName);
            }
        } else {
            this.logger.warn("ModelRepository is NULL > dispatch bindings aborted!");
        }
    }

    private void internalDispatchBindings(String modelName, Item item, EList<ModelBinding> bindings) {
        this.internalDispatchBindings(null, modelName, item, bindings);
    }

    private void internalDispatchBindings(BindingConfigReader reader, String modelName, Item item, EList<ModelBinding> bindings) {
        for (ModelBinding binding : bindings) {
            String bindingType = binding.getType();
            String config = binding.getConfiguration();
            Configuration configuration = new Configuration();
            binding.getProperties().forEach(p -> {
                Object object = configuration.put(p.getKey(), p.getValue());
            });
            BindingConfigReader localReader = reader;
            if (reader == null) {
                this.logger.trace("Given binding config reader is null > query cache to find appropriate reader!");
                localReader = this.bindingConfigReaders.get(bindingType);
            } else {
                if (!localReader.getBindingType().equals(binding.getType())) {
                    this.logger.trace("The Readers' binding type '{}' and the Bindings' type '{}' doesn't match > continue processing next binding.", (Object)localReader.getBindingType(), (Object)binding.getType());
                    continue;
                }
                this.logger.debug("Start processing binding configuration of Item '{}' with '{}' reader.", (Object)item, (Object)localReader.getClass().getSimpleName());
            }
            if (localReader != null) {
                try {
                    localReader.validateItemType(item.getType(), config);
                    localReader.processBindingConfiguration(modelName, item.getType(), item.getName(), config, configuration);
                }
                catch (BindingConfigParseException e) {
                    this.logger.error("Binding configuration of type '{}' of item '{}' could not be parsed correctly.", new Object[]{bindingType, item.getName(), e});
                }
                catch (Exception e) {
                    this.logger.error("Binding configuration of type '{}' of item '{}' could not be parsed correctly.", new Object[]{bindingType, item.getName(), e});
                }
                continue;
            }
            this.genericMetaDataProvider.addMetadata(bindingType, item.getName(), config, configuration.getProperties());
        }
    }

    public void modelChanged(String modelName, EventType type) {
        if (modelName.endsWith("items")) {
            switch (type) {
                case ADDED: 
                case MODIFIED: {
                    Map<String, Item> oldItems = this.toItemMap(this.itemsMap.get(modelName));
                    Map<String, Item> newItems = this.toItemMap(this.getItemsFromModel(modelName));
                    this.itemsMap.put(modelName, newItems.values());
                    for (Item newItem : newItems.values()) {
                        if (oldItems.containsKey(newItem.getName())) {
                            Item oldItem = oldItems.get(newItem.getName());
                            if (!this.hasItemChanged(oldItem, newItem)) continue;
                            this.notifyListenersAboutUpdatedElement(oldItem, newItem);
                            continue;
                        }
                        this.notifyListenersAboutAddedElement(newItem);
                    }
                    this.processBindingConfigsFromModel(modelName, type);
                    for (Item oldItem : oldItems.values()) {
                        if (newItems.containsKey(oldItem.getName())) continue;
                        this.notifyAndCleanup(oldItem);
                    }
                    break;
                }
                case REMOVED: {
                    this.processBindingConfigsFromModel(modelName, type);
                    Collection<Item> itemsFromModel = this.getItemsFromModel(modelName);
                    this.itemsMap.remove(modelName);
                    for (Item item : itemsFromModel) {
                        this.notifyAndCleanup(item);
                    }
                    break;
                }
            }
        }
    }

    private void notifyAndCleanup(Item oldItem) {
        this.notifyListenersAboutRemovedElement(oldItem);
        this.stateDescriptionFragments.remove(oldItem.getName());
        this.genericMetaDataProvider.removeMetadata(oldItem.getName());
    }

    protected boolean hasItemChanged(Item item1, Item item2) {
        return !Objects.equals(item1.getClass(), item2.getClass()) || !Objects.equals(item1.getName(), item2.getName()) || !Objects.equals(item1.getCategory(), item2.getCategory()) || !Objects.equals(item1.getGroupNames(), item2.getGroupNames()) || !Objects.equals(item1.getLabel(), item2.getLabel()) || !Objects.equals(item1.getTags(), item2.getTags()) || !Objects.equals(item1.getType(), item2.getType()) || this.hasGroupItemChanged(item1, item2);
    }

    private boolean hasGroupItemChanged(Item item1, Item item2) {
        GroupItem gItem1 = null;
        GroupItem gItem2 = null;
        if (item1 instanceof GroupItem) {
            gItem1 = (GroupItem)item1;
        }
        if (item2 instanceof GroupItem) {
            gItem2 = (GroupItem)item2;
        }
        if (gItem1 == null && gItem2 == null) {
            return false;
        }
        if (gItem1 != null && gItem2 == null || gItem1 == null && gItem2 != null) {
            return true;
        }
        boolean sameBaseItemClass = Objects.equals(gItem1.getBaseItem(), gItem2.getBaseItem());
        boolean sameFunction = false;
        GroupFunction gf1 = gItem1.getFunction();
        GroupFunction gf2 = gItem2.getFunction();
        if (gf1 != null && gf2 != null) {
            if (Objects.equals(gf1.getClass(), gf2.getClass())) {
                sameFunction = Arrays.equals(gf1.getParameters(), gf2.getParameters());
            }
        } else if (gf1 == null && gf2 == null) {
            sameFunction = true;
        }
        return !sameBaseItemClass || !sameFunction;
    }

    private Map<String, Item> toItemMap(Collection<Item> items) {
        if (items == null || items.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Item> ret = new LinkedHashMap<String, Item>();
        for (Item item : items) {
            ret.put(item.getName(), item);
        }
        return ret;
    }

    private Item createItemOfType(String itemType, String itemName) {
        if (itemType == null) {
            return null;
        }
        for (ItemFactory factory : this.itemFactorys) {
            Item item = factory.createItem(itemType, itemName);
            if (item == null) continue;
            this.logger.trace("Created item '{}' of type '{}'", (Object)itemName, (Object)itemType);
            return item;
        }
        this.logger.debug("Couldn't find ItemFactory for item '{}' of type '{}'", (Object)itemName, (Object)itemType);
        return null;
    }

    public @Nullable StateDescriptionFragment getStateDescriptionFragment(@NonNull String itemName, @Nullable Locale locale) {
        return this.stateDescriptionFragments.get(itemName);
    }
}

