/**
 * Copyright (c) 2014,2019 Contributors to the Eclipse Foundation
 * 
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.model.script;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smarthome.model.script.ScriptRuntimeModule;
import org.eclipse.smarthome.model.script.ScriptServiceUtil;
import org.eclipse.smarthome.model.script.ScriptStandaloneSetupGenerated;
import org.eclipse.smarthome.model.script.ServiceModule;
import org.eclipse.smarthome.model.script.engine.ScriptEngine;
import org.eclipse.xtext.resource.IResourceServiceProvider;

/**
 * Initialization support for running Xtext languages
 * without equinox extension registry
 */
@SuppressWarnings("all")
public class ScriptStandaloneSetup extends ScriptStandaloneSetupGenerated {
  private static Injector injector;
  
  private ScriptServiceUtil scriptServiceUtil;
  
  private ScriptEngine scriptEngine;
  
  public ScriptStandaloneSetup setScriptServiceUtil(final ScriptServiceUtil scriptServiceUtil) {
    this.scriptServiceUtil = scriptServiceUtil;
    return this;
  }
  
  public ScriptStandaloneSetup setScriptEngine(final ScriptEngine scriptEngine) {
    this.scriptEngine = scriptEngine;
    return this;
  }
  
  public ScriptServiceUtil getScriptServiceUtil() {
    return this.scriptServiceUtil;
  }
  
  public ScriptEngine getScriptEngine() {
    return this.scriptEngine;
  }
  
  @Override
  public Injector createInjector() {
    ServiceModule _serviceModule = new ServiceModule(this.scriptServiceUtil, this.scriptEngine);
    ScriptRuntimeModule _scriptRuntimeModule = new ScriptRuntimeModule();
    return Guice.createInjector(_serviceModule, _scriptRuntimeModule);
  }
  
  public static void doSetup(final ScriptServiceUtil scriptServiceUtil, final ScriptEngine scriptEngine) {
    if ((ScriptStandaloneSetup.injector == null)) {
      ScriptStandaloneSetup.injector = new ScriptStandaloneSetup().setScriptServiceUtil(scriptServiceUtil).setScriptEngine(scriptEngine).createInjectorAndDoEMFRegistration();
    }
  }
  
  public static Injector getInjector() {
    return ScriptStandaloneSetup.injector;
  }
  
  public static void doSetup() {
    throw new IllegalStateException();
  }
  
  public static void unregister() {
    EPackage.Registry.INSTANCE.remove("http://www.eclipse.org/smarthome/model/Script");
    Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().remove("script");
    IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap().remove("script");
    ScriptStandaloneSetup.injector = null;
  }
}
