/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.scoping;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.library.unit.ImperialUnits;
import org.eclipse.smarthome.core.library.unit.MetricPrefix;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.thing.binding.ThingActions;
import org.eclipse.smarthome.model.persistence.extensions.PersistenceExtensions;
import org.eclipse.smarthome.model.script.actions.Audio;
import org.eclipse.smarthome.model.script.actions.BusEvent;
import org.eclipse.smarthome.model.script.actions.Exec;
import org.eclipse.smarthome.model.script.actions.HTTP;
import org.eclipse.smarthome.model.script.actions.LogAction;
import org.eclipse.smarthome.model.script.actions.Ping;
import org.eclipse.smarthome.model.script.actions.ScriptExecution;
import org.eclipse.smarthome.model.script.actions.Things;
import org.eclipse.smarthome.model.script.actions.Voice;
import org.eclipse.smarthome.model.script.engine.IActionServiceProvider;
import org.eclipse.smarthome.model.script.engine.IThingActionsProvider;
import org.eclipse.smarthome.model.script.engine.action.ActionService;
import org.eclipse.smarthome.model.script.lib.NumberExtensions;
import org.eclipse.xtext.xbase.scoping.batch.ImplicitlyImportedFeatures;
import org.joda.time.DateTime;

@Singleton
public class ScriptImplicitlyImportedTypes
extends ImplicitlyImportedFeatures {
    private List<Class<?>> actionClasses = null;
    @Inject
    IActionServiceProvider actionServiceProvider;
    @Inject
    IThingActionsProvider thingActionsProvider;

    protected List<Class<?>> getExtensionClasses() {
        List result = super.getExtensionClasses();
        result.remove(Comparable.class);
        result.remove(Double.class);
        result.remove(Integer.class);
        result.remove(BigInteger.class);
        result.remove(BigDecimal.class);
        result.remove(Double.TYPE);
        result.add(NumberExtensions.class);
        result.add(StringUtils.class);
        result.add(URLEncoder.class);
        result.add(PersistenceExtensions.class);
        result.add(BusEvent.class);
        result.add(Exec.class);
        result.add(HTTP.class);
        result.add(Ping.class);
        result.add(Audio.class);
        result.add(Voice.class);
        result.add(Things.class);
        result.addAll(this.getActionClasses());
        return result;
    }

    protected List<Class<?>> getStaticImportClasses() {
        List result = super.getStaticImportClasses();
        result.add(BusEvent.class);
        result.add(Exec.class);
        result.add(HTTP.class);
        result.add(Ping.class);
        result.add(ScriptExecution.class);
        result.add(LogAction.class);
        result.add(Audio.class);
        result.add(Voice.class);
        result.add(Things.class);
        result.add(ImperialUnits.class);
        result.add(SIUnits.class);
        result.add(MetricPrefix.class);
        result.add(DateTime.class);
        result.addAll(this.getActionClasses());
        return result;
    }

    protected List<Class<?>> getActionClasses() {
        List<ThingActions> actions;
        ArrayList localActionClasses = new ArrayList();
        List<ActionService> services = this.actionServiceProvider.get();
        if (services != null) {
            for (ActionService actionService : services) {
                localActionClasses.add(actionService.getActionClass());
            }
        }
        if ((actions = this.thingActionsProvider.get()) != null) {
            for (ThingActions thingActions : actions) {
                localActionClasses.add(thingActions.getClass());
            }
        }
        this.actionClasses = localActionClasses;
        return this.actionClasses;
    }
}

