/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.sitemap.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={SitemapProvider.class})
public class SitemapProviderImpl
implements SitemapProvider,
ModelRepositoryChangeListener {
    private static final String SITEMAP_MODEL_NAME = "sitemap";
    protected static final String SITEMAP_FILEEXT = ".sitemap";
    private final Logger logger = LoggerFactory.getLogger(SitemapProviderImpl.class);
    @NonNullByDefault(value={})
    private ModelRepository modelRepo;
    private final Map<String, Sitemap> sitemapModelCache = new ConcurrentHashMap<String, Sitemap>();
    private final Set<ModelRepositoryChangeListener> modelChangeListeners = new CopyOnWriteArraySet<ModelRepositoryChangeListener>();

    @Reference
    public void setModelRepository(ModelRepository modelRepo) {
        this.modelRepo = modelRepo;
    }

    public void unsetModelRepository(ModelRepository modelRepo) {
        this.modelRepo = null;
    }

    @Activate
    protected void activate() {
        this.refreshSitemapModels();
        this.modelRepo.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
    }

    @Deactivate
    protected void deactivate() {
        if (this.modelRepo != null) {
            this.modelRepo.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        }
        this.sitemapModelCache.clear();
    }

    @Override
    public @Nullable Sitemap getSitemap(String sitemapName) {
        String filename = String.valueOf(sitemapName) + SITEMAP_FILEEXT;
        Sitemap sitemap = this.sitemapModelCache.get(filename);
        if (sitemap != null) {
            if (!sitemap.getName().equals(sitemapName)) {
                this.logger.warn("Filename `{}` does not match the name `{}` of the sitemap - please fix this as you might see unexpected behavior otherwise.", (Object)filename, (Object)sitemap.getName());
            }
            return sitemap;
        }
        this.logger.trace("Sitemap {} cannot be found", (Object)sitemapName);
        return null;
    }

    @Override
    public Set<String> getSitemapNames() {
        return this.sitemapModelCache.keySet().stream().map(name -> StringUtils.removeEnd((String)name, (String)SITEMAP_FILEEXT)).collect(Collectors.toSet());
    }

    public void modelChanged(String modelName, EventType type) {
        if (modelName.endsWith(SITEMAP_FILEEXT)) {
            if (type == EventType.REMOVED) {
                this.sitemapModelCache.remove(modelName);
            } else {
                EObject sitemap = this.modelRepo.getModel(modelName);
                if (sitemap instanceof Sitemap) {
                    this.sitemapModelCache.put(modelName, (Sitemap)sitemap);
                }
            }
        }
        for (ModelRepositoryChangeListener listener : this.modelChangeListeners) {
            listener.modelChanged(modelName, type);
        }
    }

    private void refreshSitemapModels() {
        this.sitemapModelCache.clear();
        Iterable sitemapNames = this.modelRepo.getAllModelNamesOfType(SITEMAP_MODEL_NAME);
        for (String sitemapName : sitemapNames) {
            this.sitemapModelCache.put(sitemapName, (Sitemap)this.modelRepo.getModel(sitemapName));
        }
    }

    @Override
    public void addModelChangeListener(ModelRepositoryChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    @Override
    public void removeModelChangeListener(ModelRepositoryChangeListener listener) {
        this.modelChangeListeners.remove(listener);
    }
}

