/**
 * Copyright (c) 2014,2019 Contributors to the Eclipse Foundation
 * 
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.model.thing.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.smarthome.model.thing.ThingRuntimeModule;
import org.eclipse.smarthome.model.thing.ThingStandaloneSetup;
import org.eclipse.smarthome.model.thing.ide.ThingIdeModule;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class ThingIdeSetup extends ThingStandaloneSetup {
  @Override
  public Injector createInjector() {
    ThingRuntimeModule _thingRuntimeModule = new ThingRuntimeModule();
    ThingIdeModule _thingIdeModule = new ThingIdeModule();
    return Guice.createInjector(Modules2.mixin(_thingRuntimeModule, _thingIdeModule));
  }
}
