/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.basic.internal.render;

import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.Setpoint;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.basic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.basic.render.RenderException;
import org.eclipse.smarthome.ui.basic.render.WidgetRenderer;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={WidgetRenderer.class})
public class SetpointRenderer
extends AbstractWidgetRenderer {
    @Override
    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        super.deactivate(bundleContext);
    }

    @Override
    public boolean canRender(Widget w) {
        return w instanceof Setpoint;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        BigDecimal maxValue;
        BigDecimal minValue;
        Setpoint sp = (Setpoint)w;
        State state = this.itemUIRegistry.getState(w);
        String newLowerState = state.toString();
        String newHigherState = state.toString();
        BigDecimal step = sp.getStep();
        if (step == null) {
            step = BigDecimal.ONE;
        }
        if ((minValue = sp.getMinValue()) == null) {
            minValue = BigDecimal.ZERO;
        }
        if ((maxValue = sp.getMaxValue()) == null) {
            maxValue = BigDecimal.valueOf(100L);
        }
        if (state instanceof DecimalType) {
            DecimalType actState = (DecimalType)state;
            BigDecimal newLower = actState.toBigDecimal().subtract(step);
            BigDecimal newHigher = actState.toBigDecimal().add(step);
            if (newLower.compareTo(minValue) < 0) {
                newLower = minValue;
            }
            if (newHigher.compareTo(maxValue) > 0) {
                newHigher = maxValue;
            }
            newLowerState = newLower.toString();
            newHigherState = newHigher.toString();
        }
        String unit = this.getUnitForWidget(w);
        String snippetName = "setpoint";
        String snippet = this.getSnippet(snippetName);
        snippet = this.preprocessSnippet(snippet, w);
        snippet = StringUtils.replace((String)snippet, (String)"%newlowerstate%", (String)newLowerState);
        snippet = StringUtils.replace((String)snippet, (String)"%newhigherstate%", (String)newHigherState);
        snippet = StringUtils.replace((String)snippet, (String)"%value%", (String)this.getValue(w));
        snippet = StringUtils.replace((String)snippet, (String)"%minValue%", (String)minValue.toString());
        snippet = StringUtils.replace((String)snippet, (String)"%maxValue%", (String)maxValue.toString());
        snippet = StringUtils.replace((String)snippet, (String)"%step%", (String)step.toString());
        snippet = StringUtils.replace((String)snippet, (String)"%unit%", (String)unit);
        snippet = this.processColor(w, snippet);
        sb.append(snippet);
        return null;
    }

    @Override
    @Reference
    protected void setItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.setItemUIRegistry(ItemUIRegistry2);
    }

    @Override
    protected void unsetItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.unsetItemUIRegistry(ItemUIRegistry2);
    }
}

